
{
           *********************************************************
           *     Copyright 1983 Mindset Corp. This program         *
           *     is an unpublished work of authorship protected    *
           *     by the copyright laws of the United States.       *
           *     This program is also the confidential,            *
           *     proprietary information of Mindset Corp. and      *
           *     is not to be copied, used or altered in any       *
           *     way without the express permission of Mindset     *
           *     Corp.                                             *
           *********************************************************

           *********************************************************
           *  This program is designated a Mindset Utility as      *
           *  defined in the Mindset Corp. Development Software    *
           *  License Agreement.                                   *
           *********************************************************

}

{BIOS.PAS -- Pascal calls for bios entry points}
{$list-}
{$symtab-}

module bios_calls;

const
{$include:'bios.cst'}

type
{$include:'bios.typ'}


{--------------------------------------------------------------------}
{--------------------------------------------------------------------}

{-------------------------}
{External ASM86 procedures}
{-------------------------}

procedure bios_interrupt(int_vector: integer;
			 vars registers: reg_block); extern;

{------------------}
{Utility procedures}
{------------------}

procedure get_word_addr(vars variable: word;
			var address_offset:word;
			var address_segment: word);
var
       addr: ads of word;
begin
{Returns the offset/segment address of a variable}
	addr := ads variable;
	address_offset := addr.r;
	address_segment := addr.s;
end;

procedure get_integer_addr(vars variable: integer;
			   var address_offset:word;
			   var address_segment: word);
var
       addr: ads of integer;
begin
{Returns the offset/segment address of a variable}
	addr := ads variable;
	address_offset := addr.r;
	address_segment := addr.s;
end;

procedure get_char_addr(vars variable: char;
			var address_offset:word;
			var address_segment: word);
var
       	addr: ads of char;
begin
{Returns the offset/segment address of a variable}
	addr := ads variable;
	address_offset := addr.r;
	address_segment := addr.s;
end;


{------------------------------------------------}
{procedures for IBM compatible video entry points}
{------------------------------------------------}

procedure set_ibm_mode(mode: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_set_mode);
    reg.ax.byte[low] := chr(mode);
    bios_interrupt(ibm_io_int,reg);
end {set_ibm_mode};

{--------------------------------------------------------------------}

procedure set_cursor_position(page: byte;
			      row: byte;
			      column: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_set_cursor_position);
    reg.bx.byte[high] := chr(page);
    reg.dx.byte[high] := chr(row);
    reg.dx.byte[low]  := chr(column);
    bios_interrupt(ibm_io_int,reg);
end {set_cursor_position};

{--------------------------------------------------------------------}

procedure read_cursor_position(page: byte;
			       var row: byte;
			       var column: byte;
                      var cursor_start: byte;
                      var cursor_end: byte);
    var
	reg: reg_block;
     dummy: reg_typ;
begin
    reg.ax.byte[high] := chr(ibm_read_cursor_position);
    reg.bx.byte[high] := chr(page);
    bios_interrupt(ibm_io_int,reg);
    dummy.signed := ord(reg.dx.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    row := dummy.word;
    dummy.signed := ord(reg.dx.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    column := dummy.word;
    dummy.signed := ord(reg.cx.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    cursor_start := dummy.word;
    dummy.signed := ord(reg.cx.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    cursor_end := dummy.word;
end {read_cursor_position};

{------------------------------------------------}

procedure write_dot(row: integer;
                    column: integer;
                    color: byte);

    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_write_dot);
    reg.ax.byte[low] := chr(color);
    reg.dx.signed := row;
    reg.cx.signed := column;
    bios_interrupt(ibm_io_int,reg);
end {write_dot};

{------------------------------------------------}

procedure read_dot(row: integer;
                   column: integer;
                   var color: byte);

    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ibm_read_dot);
    reg.dx.signed := row;
    reg.cx.signed := column;
    bios_interrupt(ibm_io_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    color := dummy.word;
end {read_dot};

{--------------------------------------------------------------------}

procedure write_teletype(page: byte;
			 character: char;
			 color: byte);		    
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_write_teletype);
    reg.ax.byte[low] := character;
    reg.bx.byte[high] := chr(page);
    reg.bx.byte[low] := chr(color);
    bios_interrupt(ibm_io_int,reg);
end {write_teletype};


{--------------------------------------------------------------------}

procedure write_char_only(page: byte;
			  character: char;
			  count: integer;
			  color: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_write_char_only);
    reg.ax.byte[low] := character;
    reg.bx.byte[high] := chr(page);
    reg.bx.byte[low] := chr(color);
    reg.cx.signed := count;
    bios_interrupt(ibm_io_int,reg);
end {write_char_only};


{--------------------------------------------------------------------}
{--------------------------------------------------------------------}




{---------------------------------------------}
{procedures for IBM compatible rs232 interface}
{---------------------------------------------}

procedure rs232_init(params: byte;
                     module_number: integer);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ibm_rs232_init);
    dummy.word := params;
    reg.ax.byte[low] := chr(dummy.signed);
    reg.dx.signed := module_number;
    bios_interrupt(ibm_rs232_int,reg);
end {rs232_init};


procedure rs232_send_char(character: char;
                          module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_rs232_send_char);
    reg.ax.byte[low] := character;
    reg.dx.signed := module_number;
    bios_interrupt(ibm_rs232_int,reg);
end {rs232_send_char};


procedure rs232_rcv_char(var character: char;
                         module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_rs232_rcv_char);
    reg.dx.signed := module_number;
    bios_interrupt(ibm_rs232_int,reg);
    character := reg.ax.byte[low];
end {rs232_rcv_char};


procedure rs232_get_status(var port_status: word;
                           module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ibm_rs232_get_status);
    reg.dx.signed := module_number;
    bios_interrupt(ibm_rs232_int,reg);
    port_status := reg.ax.word;
end {rs232_get_status};



{--------------------------------------------------------------------}
{--------------------------------------------------------------------}


{---------------------------------------------------}
{procedures for IBM compatible keyboard entry points}
{---------------------------------------------------}

procedure get_kb_char(var character: char;
		      var scan_code: byte);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ibm_get_kb_char);
    bios_interrupt(ibm_keyboard_int,reg);
    character := reg.ax.byte[low];
    dummy.signed := ord(reg.ax.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    scan_code := dummy.word;
end {get_kb_char};

{--------------------------------------------------------------------}

procedure test_kb_buffer(var character_present: boolean;
			 var character: char;
			 var scan_code: byte);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ibm_test_kb_buffer);
    bios_interrupt(ibm_keyboard_int,reg);
    if (reg.flags.word and 2#1000000) <> 0 then
	character_present := false
    else
	begin
	character_present := true;
	character := reg.ax.byte[low];
	dummy.signed := ord(reg.ax.byte[high]);
     if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
     scan_code := dummy.word;
	end;
end {test_kb_buffer};

{--------------------------------------------------------------------}

procedure get_kb_shift_status(var kb_flag: byte);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ibm_get_kb_shift_status);
    bios_interrupt(ibm_keyboard_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    kb_flag := dummy.word;
end {get_kb_shift_status};


{--------------------------------------------------------------------}
{--------------------------------------------------------------------}


{----------------------------------------}
{procedures for temporary rs232 interface}
{----------------------------------------}

procedure temp_rs232_init(params: byte;
                          module_number: integer);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_temp_rs232_init);
    dummy.word := params;
    reg.ax.byte[low] := chr(dummy.signed);
    reg.dx.signed := module_number;
    bios_interrupt(ms_temp_rs232_int,reg);
end {temp_rs232_init};


procedure temp_rs232_send_char(character: char;
                               module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_temp_rs232_send_char);
    reg.ax.byte[low] := character;
    reg.dx.signed := module_number;
    bios_interrupt(ms_temp_rs232_int,reg);
end {temp_rs232_send_char};


procedure temp_rs232_rcv_char(var character: char;
                              module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_temp_rs232_rcv_char);
    reg.dx.signed := module_number;
    bios_interrupt(ms_temp_rs232_int,reg);
    character := reg.ax.byte[low];
end {temp_rs232_rcv_char};


procedure temp_rs232_get_status(var port_status: word;
                                module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_temp_rs232_get_status);
    reg.dx.signed := module_number;
    bios_interrupt(ms_temp_rs232_int,reg);
    port_status := reg.ax.word;
end {temp_rs232_get_status};




{--------------------------------------------------------------------}
{--------------------------------------------------------------------}



{---------------------------------------------}
{procedures for Mindset unique io entry points}
{---------------------------------------------}

procedure set_display_device(tv_monitor: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_display_device);
    reg.ax.byte[low] := chr(tv_monitor); {0=tv, 1=monitor}
    bios_interrupt(ms_io_int,reg);
end {set_display_device};


{--------------------------------------------------------------------}

procedure set_ext_sync(mode: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_ext_sync);
    reg.ax.byte[low] := chr(mode);
    bios_interrupt(ms_io_int,reg);
end {set_ext_sync};


{--------------------------------------------------------------------}

procedure set_display_int(scan_line: integer;
						  diagnostic_mark: integer);

	var
		reg: reg_block;

begin
	reg.ax.byte[high] := chr(ms_set_display_int);
	reg.ax.byte[low]  := chr(scan_line);
	reg.bx.byte[low]  := chr(diagnostic_mark);
	bios_interrupt(ms_io_int,reg);
end {set_display_int};

{--------------------------------------------------------------------}


procedure joystick_io(var a_switch: byte;
		      var b_switch: byte;
		      var a_x: integer;
		      var a_y: integer;
		      var b_x: integer;
		      var b_y: integer);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_joystick_io);
    bios_interrupt(ms_io_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    a_switch := dummy.word;
    dummy.signed := ord(reg.ax.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    b_switch := dummy.word;
    a_x := reg.bx.signed;
    a_y := reg.cx.signed;
    b_x := reg.dx.signed;
    b_y := reg.si.signed;
end {joystick_io};


{--------------------------------------------------------------------}


procedure rs232_write_char(character: char;
                           module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_rs232_write_char);
    reg.ax.byte[low] := character;
    reg.dx.signed := module_number;
    bios_interrupt(ms_io_int,reg);
end {rs232_write_char};


{--------------------------------------------------------------------}


procedure rs232_read_char(var character: char;
                          var comm_status: byte;
                          module_number: integer);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_rs232_read_char);
    reg.dx.signed := module_number;
    bios_interrupt(ms_io_int,reg);
    dummy.signed := ord(reg.ax.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    comm_status := dummy.word;
    character := reg.ax.byte[low];
end {rs232_read_char};


{--------------------------------------------------------------------}


procedure rs232_write_string(string_offset: word;
                             string_segment: word;
                             character_count: integer;
                             module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_rs232_write_string);
    reg.bx.word := string_offset;
    reg.cx.signed := character_count;
    reg.dx.signed := module_number;
    reg.es.word := string_segment;
    bios_interrupt(ms_io_int,reg);
end {rs232_write_string};


{--------------------------------------------------------------------}


procedure rs232_get_buffer_status(var buffer_status: byte;
                                  var avail_words_input: integer;
                                  var avail_words_output: integer;
                                  module_number: integer);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_rs232_get_buffer_status);
    reg.dx.signed := module_number;
    bios_interrupt(ms_io_int,reg);
    dummy.signed := ord(reg.ax.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    buffer_status := dummy.word;
    avail_words_input := reg.bx.signed;
    avail_words_output := reg.cx.signed;
end {rs232_get_buffer_status};


{--------------------------------------------------------------------}


procedure rs232_set_input_buffer(buffer_offset: word;
                                 buffer_segment: word;
                                 size_in_words: integer;
                                 module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_rs232_set_input_buffer);
    reg.bx.word := buffer_offset;
    reg.cx.signed := size_in_words;
    reg.dx.signed := module_number;
    reg.es.word := buffer_segment;
    bios_interrupt(ms_io_int,reg);
end {rs232_set_input_buffer};


{--------------------------------------------------------------------}


procedure rs232_set_output_buffer(buffer_offset: word;
                                  buffer_segment: word;
                                  size_in_words: integer;
                                  module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_rs232_set_output_buffer);
    reg.bx.word := buffer_offset;
    reg.cx.signed := size_in_words;
    reg.dx.signed := module_number;
    reg.es.word := buffer_segment;
    bios_interrupt(ms_io_int,reg);
end {rs232_set_output_buffer};


{--------------------------------------------------------------------}


procedure rs232_set_comm_controls(rts_dtr: byte;
                                  tx_rs_interrupts: byte;
                                  module_number: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_rs232_set_comm_controls);
    reg.ax.byte[low] := chr(rts_dtr);
    reg.bx.byte[low] := chr(tx_rs_interrupts);
    reg.dx.signed := module_number;
    bios_interrupt(ms_io_int,reg);
end {rs232_set_comm_controls};


{--------------------------------------------------------------------}


procedure rs232_get_comm_controls(var rts_dtr: byte;
                                  var tx_rs_interrupts: byte;
                                  module_number: integer);
    var
	reg: reg_block;
        dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_rs232_get_comm_controls);
    reg.dx.signed := module_number;
    bios_interrupt(ms_io_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    rts_dtr := dummy.word;
    dummy.signed := ord(reg.bx.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    tx_rs_interrupts := dummy.word;
end {rs232_get_comm_controls};


{--------------------------------------------------------------------}


procedure rs232_get_modem_status(var modem_status: byte;
                                 module_number: integer);
    var
	reg: reg_block;
        dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_rs232_get_modem_status);
    reg.dx.signed := module_number;
    bios_interrupt(ms_io_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    modem_status := dummy.word;
end {rs232_get_modem_status};



{--------------------------------------------------------------------}
{--------------------------------------------------------------------}


{------------------------------------------------}
{procedures for Mindset unique video entry points}
{------------------------------------------------}


procedure set_screen_mode(mode: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_screen_mode);
    reg.ax.byte[low] := chr(mode);
    bios_interrupt(mindset_video_int,reg);
end {set_screen_mode};

{--------------------------------------------------------------------}

procedure get_screen_mode(var mode: byte;
			  var flags: word;
			  var bits_per_pixel: integer);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_get_screen_mode);
    bios_interrupt(mindset_video_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    mode := dummy.word;
    flags := reg.bx.word;
    bits_per_pixel := reg.cx.signed;
end {get_screen_mode};

{--------------------------------------------------------------------}

{--------------------------------------------------------------------}


procedure set_transfer_mode(mode: byte;
			    logical: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_transfer_mode);
    reg.bx.byte[high] := chr(mode);
    reg.bx.byte[low] := chr(logical);
    bios_interrupt(mindset_video_int,reg);
end {set_transfer_mode};

{--------------------------------------------------------------------}

procedure get_transfer_mode(var mode: byte;
			    var logical: byte);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_get_transfer_mode);
    bios_interrupt(mindset_video_int,reg);
    dummy.signed := ord(reg.bx.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    mode := dummy.word;
    dummy.signed := ord(reg.bx.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    logical := dummy.word;
end {get_transfer_mode};

{--------------------------------------------------------------------}


procedure set_dest_buffer(buffer_offset_addr: word;
			  buffer_segment_addr: word;
			  width: integer;
			  lines: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_dest_buffer);
    reg.bx.word := buffer_offset_addr;
    reg.es.word := buffer_segment_addr;
    reg.cx.signed := width;
    reg.dx.signed := lines;
    bios_interrupt(mindset_video_int,reg);
end {set_transfer_mode};

{--------------------------------------------------------------------}

procedure get_dest_buffer(var buffer_offset_addr: word;
			  var buffer_segment_addr: word;
			  var width: integer;
			  var lines: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_get_dest_buffer);
    bios_interrupt(mindset_video_int,reg);
    buffer_offset_addr := reg.bx.word;
    buffer_segment_addr := reg.es.word;
    width := reg.cx.signed;
    lines := reg.dx.signed;
end {get_transfer_mode};

{--------------------------------------------------------------------}


procedure set_write_mask(mask: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_write_mask);
    reg.bx.word := mask;
    bios_interrupt(mindset_video_int,reg);
end {set_write_mask};

{--------------------------------------------------------------------}

procedure get_write_mask(var mask: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_get_write_mask);
    bios_interrupt(mindset_video_int,reg);
    mask := reg.bx.word;
end {get_write_mask};

{--------------------------------------------------------------------}


procedure blt_copy(blt_id: byte;
		   n_blts: integer;
                   modes: integer;
		   xorg: integer;
		   yorg: integer;
		   data_offset: word;
		   data_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_blt_copy);
    reg.ax.byte[low] := chr(blt_id);
    reg.cx.signed := n_blts;
    reg.dx.signed := modes;
    reg.si.signed := xorg;
    reg.di.signed := yorg;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {blt_copy};

{--------------------------------------------------------------------}


procedure blt_copy_word(blt_id: byte;
			n_blts: integer;
			xorg: integer;
			yorg: integer;
			data_offset: word;
			data_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_blt_copy_word);
    reg.ax.byte[low] := chr(blt_id);
    reg.cx.signed := n_blts;
    reg.si.signed := xorg;
    reg.di.signed := yorg;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {blt_copy_word};

{--------------------------------------------------------------------}


procedure set_palette(border_index: byte;
		      offset: integer;
		      nwords: integer;
		      data_offset: word;
		      data_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_palette);
    reg.ax.byte[low] := chr(border_index);
    reg.cx.signed := nwords;
    reg.dx.signed := offset;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {set_palette};

{--------------------------------------------------------------------}

procedure get_palette(var border_index: byte;
		      offset: integer;
		      nwords: integer;
		      data_offset: word;
		      data_segment: word);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_get_palette);
    reg.cx.signed := nwords;
    reg.dx.signed := offset;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    border_index := dummy.word;
end {get_palette};

{--------------------------------------------------------------------}


procedure blt_polypoint(blt_id: byte;
			n_points: integer;
			color_index: byte;
			xorg: integer;
			yorg: integer;
			data_offset: word;
			data_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_blt_polypoint);
    reg.ax.byte[low] := chr(blt_id);
    reg.cx.signed := n_points;
    reg.dx.byte[high] := chr(color_index);
    reg.si.signed := xorg;
    reg.di.signed := yorg;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {blt_polypoint};

{--------------------------------------------------------------------}


procedure blt_polyline(blt_id: byte;
		       n_points: integer;
		       color_index: byte;
		       mode: polyline_mode;
		       xorg: integer;
		       yorg: integer;
		       data_offset: word;
		       data_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_blt_polyline);
    reg.ax.byte[low] := chr(blt_id);
    reg.cx.signed := n_points;
    reg.dx.byte[high] := chr(color_index);
    if (mode = chained) then
	reg.dx.byte[low] := chr(0)
    else
	reg.dx.byte[low] := chr(1);
    reg.si.signed := xorg;
    reg.di.signed := yorg;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {blt_polyline};

{--------------------------------------------------------------------}


procedure blt_polygon(blt_id: byte;
		      n_points: integer;
		      even_color_index: byte;
		      odd_color_index: byte;
		      xorg: integer;
		      yorg: integer;
		      data_offset: word;
		      data_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_blt_polygon);
    reg.ax.byte[low] := chr(blt_id);
    reg.cx.signed := n_points;
    reg.dx.byte[high] := chr(even_color_index);
    reg.dx.byte[low] := chr(odd_color_index);
    reg.si.signed := xorg;
    reg.di.signed := yorg;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {blt_polygon};

{--------------------------------------------------------------------}


procedure blt_ellipses(blt_id: byte;
		       interior: interior_style;
		       n_points: integer;
		       even_color_index: byte;
		       odd_color_index: byte;
		       xorg: integer;
		       yorg: integer;
		       data_offset: word;
		       data_segment: word);
    var
	reg: reg_block;

begin
    if (interior = filled) then
	reg.ax.byte[high] := chr(ms_blt_ellipses_filled)
    else
	reg.ax.byte[high] := chr(ms_blt_ellipses_arcs);
    reg.ax.byte[low] := chr(blt_id);
    reg.cx.signed := n_points;
    reg.dx.byte[high] := chr(even_color_index);
    reg.dx.byte[low] := chr(odd_color_index);
    reg.si.signed := xorg;
    reg.di.signed := yorg;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {blt_ellipses};

{--------------------------------------------------------------------}


procedure set_clip_rectangle(xleft: integer;
			     xright: integer;
			     ytop: integer;
			     ybottom: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_clip_rectangle);
    reg.si.signed := xleft;
    reg.di.signed := xright;
    reg.cx.signed := ytop;
    reg.dx.signed := ybottom;
    bios_interrupt(mindset_video_int,reg);
end {set_clip_rectangle};

{--------------------------------------------------------------------}

procedure get_clip_rectangle(var xleft: integer;
			     var xright: integer;
			     var ytop: integer;
			     var ybottom: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_get_clip_rectangle);
    bios_interrupt(mindset_video_int,reg);
    xleft := reg.si.signed;
    xright := reg.di.signed;
    ytop := reg.cx.signed;
    ybottom := reg.dx.signed;
end {get_clip_rectangle};

{--------------------------------------------------------------------}


procedure set_collision_pattern(polarity: collision_polarity;
				pattern: byte;
				mask: byte);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_collision_pattern);
    if (polarity = collide_on) then
	reg.ax.byte[low] := chr(0)
    else
	reg.ax.byte[low] := chr(1);
    reg.bx.byte[high] := chr(mask);
    reg.bx.byte[low] := chr(pattern);
    bios_interrupt(mindset_video_int,reg);
end {set_collision_pattern};

{--------------------------------------------------------------------}

procedure get_collision_pattern(var polarity: collision_polarity;
				var pattern: byte;
				var mask: byte);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_get_collision_pattern);
    bios_interrupt(mindset_video_int,reg);
    if (reg.ax.byte[low] = chr(0)) then
	polarity := collide_on
    else
	polarity := collide_on_all_except;
    dummy.signed := ord(reg.bx.byte[high]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    mask := dummy.word;
    dummy.signed := ord(reg.bx.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    pattern := dummy.word;
end {get_collision_pattern};

{--------------------------------------------------------------------}


procedure set_collclip_detect(mode: byte;
			      address_offset: word;
			      address_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_collclip_detect);
    reg.ax.byte[low]  := chr(mode);
    reg.bx.word := address_offset;
    reg.es.word := address_segment;
    bios_interrupt(mindset_video_int,reg);
end {set_collclip_detect};

{--------------------------------------------------------------------}

procedure get_collclip_detect(var mode: byte;
			      var address_offset: word;
			      var address_segment: word);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_get_collclip_detect);
    bios_interrupt(mindset_video_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    mode := dummy.word;
    address_offset := reg.bx.word;
    address_segment := reg.es.word;
end {get_collclip_detect};

{--------------------------------------------------------------------}


procedure set_display_int_addr(address_offset: word;
			       address_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_display_int_addr);
    reg.bx.word := address_offset;
    reg.es.word := address_segment;
    bios_interrupt(mindset_video_int,reg);
end {set_display_int_addr};

{--------------------------------------------------------------------}

procedure get_display_int_addr(var address_offset: word;
			       var address_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_get_display_int_addr);
    bios_interrupt(mindset_video_int,reg);
    address_offset := reg.bx.word;
    address_segment := reg.es.word;
end {get_display_int_addr};

{--------------------------------------------------------------------}


procedure get_buffer_info(var fb1_segment_addr: word;
			  var fb2_segment_addr: word;
			  var fb_byte_size: integer;
			  var char_80_segment_addr: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_get_buffer_info);
    bios_interrupt(mindset_video_int,reg);
    fb1_segment_addr := reg.bx.word;
    fb2_segment_addr := reg.dx.word;
    fb_byte_size := reg.cx.signed;
    char_80_segment_addr := reg.si.word;
end {get_buffer_info};

{--------------------------------------------------------------------}


procedure switch_active_buffer;
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_switch_active_buffer);
    bios_interrupt(mindset_video_int,reg);
end {switch_active_buffer};

{--------------------------------------------------------------------}


procedure blt_wait(var blt_id: byte;
		   var collisions: word;
		   var clips: word);
    var
	reg: reg_block;
     dummy: reg_typ;

begin
    reg.ax.byte[high] := chr(ms_blt_wait);
    bios_interrupt(mindset_video_int,reg);
    dummy.signed := ord(reg.ax.byte[low]);
    if dummy.signed < 0 then dummy.signed := 256 + dummy.signed;
    blt_id := dummy.word;
    collisions := reg.bx.word;
    clips := reg.cx.word;
end {blt_wait};

{--------------------------------------------------------------------}


procedure save_blter(mode: byte;
		     data_offset: word;
		     data_segment: word;
		     var data_size: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_save_blter);
    reg.ax.byte[low]  := chr(mode);
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
    reg.ax.signed := data_size;
end {save_blter};

{--------------------------------------------------------------------}

procedure restore_blter(data_offset: word;
			data_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_restore_blter);
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {restore_blter};

{--------------------------------------------------------------------}


procedure fill_dest_buffer(fill_data: integer);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_fill_dest_buffer);
    reg.bx.signed := fill_data;
    bios_interrupt(mindset_video_int,reg);
end {fill_dest_buffer};

{--------------------------------------------------------------------}


procedure set_font_pointer(address_offset: word;
			   address_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_set_font_pointer);
    reg.bx.word := address_offset;
    reg.es.word := address_segment;
    bios_interrupt(mindset_video_int,reg);
end {set_font_pointer};

{--------------------------------------------------------------------}

procedure get_font_pointer(var address_offset: word;
			   var address_segment: word);
    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_get_font_pointer);
    bios_interrupt(mindset_video_int,reg);
    address_offset := reg.bx.word;
    address_segment := reg.es.word;
end {get_font_pointer};

{--------------------------------------------------------------------}

procedure blt_string(blt_id: byte;
		     n_strings: byte;
		     n_ignore: byte;
		     direction: byte;
		     mask: byte;
		     xorg: integer;
		     yorg: integer;
		     data_offset: word;
		     data_segment: word);

    var
	reg: reg_block;

begin
    reg.ax.byte[high] := chr(ms_blt_string);
    reg.ax.byte[low] := chr(blt_id);
    reg.cx.byte[high] := chr(n_strings);
    reg.cx.byte[low] := chr(n_ignore);
    reg.dx.byte[high] := chr(direction);
    reg.dx.byte[low] := chr(mask);
    reg.si.signed := xorg;
    reg.di.signed := yorg;
    reg.bx.word := data_offset;
    reg.es.word := data_segment;
    bios_interrupt(mindset_video_int,reg);
end {blt_string};

{--------------------------------------------------------------------}

procedure set_link_mode(mode: byte);

	var
		reg: reg_block;

begin
	reg.ax.byte[high] := chr(ms_set_param_block_mode);
	reg.ax.byte[low]  := chr(mode);
	bios_interrupt(mindset_video_int,reg);
end	{set_link_mode};

{--------------------------------------------------------------------}

procedure get_link_mode(var mode: byte);

	var
		reg: reg_block;
		dummy: reg_typ;

begin
	reg.ax.byte[high] := chr(ms_get_param_block_mode);
	bios_interrupt(mindset_video_int,reg);
	dummy.signed := ord(reg.ax.byte[low]);
	if dummy.signed < 0  then dummy.signed := 256 + dummy.signed;
	mode := dummy.word;
end	{get_link_mode};

{--------------------------------------------------------------------}

procedure get_gcp_status(var gcp_idle: integer;
						 var system_fly: integer;
						 var collision_detected: integer);

	var
		reg: reg_block;

begin
	reg.ax.byte[high] := chr(ms_get_blter_status);
	bios_interrupt(mindset_video_int,reg);
	gcp_idle			:= reg.bx.signed AND 16#0001;	
	system_fly			:= reg.bx.signed AND 16#0002;
	collision_detected	:= reg.bx.signed AND 16#0004;
end {get_gcp_status};

{--------------------------------------------------------------------}

procedure get_char_bitmap(var normal_font: integer;
						  var extras_font: integer;
						  var segment: integer);

	var
		reg: reg_block;

begin
	reg.ax.byte[high] := chr(ms_get_char_bitmap);
	bios_interrupt(mindset_video_int,reg);
	normal_font	:= reg.si.signed;
	extras_font	:= reg.di.signed;
	segment		:= reg.es.signed;
end {get_char_bitmap};

{--------------------------------------------------------------------}

procedure get_gcp_memory(var memory_flag: integer;
						 var first_segment: integer;
						 var last_segment: integer);

	var
		reg: reg_block;

begin
	reg.ax.byte[high] := chr(ms_get_gcp_memory);
	bios_interrupt(mindset_video_int,reg);
	memory_flag		:= reg.ax.signed AND 16#0001;
	first_segment	:= reg.si.signed;
	last_segment	:= reg.di.signed;
end {get_gcp_memory};

{--------------------------------------------------------------------}

end {module bios_calls}.
