title Convert Epson FX286 special code to okidata okigraph 1
page 65,132

epson_dat	segment	public	'data'
state		dw	?
cnt		dw	?
buffer		db	2000 dup(?)
buf_cnt		dw	?
epson_dat	ends

oki_epson	segment	public	'code'
		assume	cs:oki_epson,ds:epson_dat

start:
	mov	ax,epson_dat
	mov	ds,ax

	mov	buf_cnt,0
	mov	cnt,0
	mov	state,0
	mov	ah,35h
	mov	al,17h
	int	21h

	push	ds
	mov	dx,es
	mov	ds,dx
	mov	dx,bx
	mov	ah,25h
	mov	al,0ffh
	int	21h
	pop	ds

	push	ds
	mov	ah,25h		; set vector id
	mov	al,17h		; printer I/O interrupt
	mov	dx,seg dmp
	mov	ds,dx
	mov	dx,offset dmp
	int	21h		; new print screen vector
	pop	ds
	mov	dx,offset dmp_end
	mov	cx,4
	shl	dx,cl
	int	27h

dmp:
	push	ds
	push	bx
	push	cx
	push	di
	mov	bx,epson_dat
	mov	ds,bx

	mov	bx,state
	shl	bx,1
	add	bx,offset table
	call	bx
	and	ah,80h
	pop	di
	pop	cx
	pop	bx
	pop	ds
	iret

state0:
	cmp	al,1bh
	jz	state01
	int	0ffh
	ret
state01:
	inc	state
	mov	ah,80h
	ret

state1:
	cmp	al,4ch
	jz	state11
	mov	state,0
	mov	ah,80h
	ret
state11:
	inc	state
	mov	ah,80h
	ret

state2:
	xor	ah,ah
	mov	cnt,ax
	inc	state
	mov	ah,80h
	ret

state3:
	xor	ah,ah
	mov	bx,256
	mul	bx
	add	cnt,ax
	inc	state

	mov	ah,0
	mov	al,3
	int	0ffh
	mov	ah,80h
	ret

table:
	jmp	short state0
	jmp	short state1
	jmp	short state2
	jmp	short state3
	jmp	short state4
	jmp	short state5
	jmp	short state6

state4:
	mov	di,buf_cnt
	mov	buffer[di],al
	inc	buf_cnt
	ror	al,1
	mov	cl,al
	and	cl,88h
	mov	ch,cl
	ror	al,1
	ror	al,1
	mov	cl,al
	and	cl,44h
	or	ch,cl
	ror	al,1
	ror	al,1
	mov	cl,al
	and	cl,22h
	or	ch,cl
	ror	al,1
	ror	al,1
	mov	cl,al
	and	cl,11h
	or	ch,cl
	mov	al,ch

	cmp	al,3
	jnz	state40
	int	0ffh
	mov	ah,0
	mov	al,03
state40:
	int	0ffh
	dec	cnt
	jz	state41
	mov	ah,80h
	ret

state41:
	inc	state
	mov	ah,80h
	ret

state5:
	cmp	al,0ah
	jnz	state51
	inc	state
state51:
	mov	ah,80h
	ret

state6:
	cmp	al,0dh
	jnz	state61
	mov	ah,0
	mov	al,3
	int	0ffh
	mov	ah,0
	mov	al,0eh		; Graphics CR,LF
	int	0ffh

; Print buffered bits 0 from epson format
; after bit 0 becomes bit 7 for Okidata, it  will be ignored
	mov	cx,buf_cnt
	mov	di,0
state62:
	mov	al,buffer[di]
	and	al,1
	mov	ah,0
	int	0ffh
	inc	di
	loop	state62
;
; Exit graphics mode
	mov	ah,0
	mov	al,3
	int	0ffh
	mov	ah,0
	mov	al,2
	int	0ffh

; Now advance the printer one dot position
	mov	al,1bh
	mov	ah,0
	int	0ffh
	mov	al,25h
	mov	ah,0
	int	0ffh
	mov	al,39h
	mov	ah,0
	int	0ffh
	mov	al,1
	mov	ah,0
	int	0ffh
;
	mov	buf_cnt,0
	mov	state,0
state61:
	mov	ah,80h
	ret

dmp_end:

oki_epson	ends
		end
