STACK		SEGMENT PARA STACK 'STACK'
		DB 30 DUP ('STACK')
STACK		ENDS
	
WORK_AREA	SEGMENT	PARA PUBLIC 'DATA'

PALET_BUFF	DW	17 DUP(00)

DEST_BUFF_ADR	DW	00
DEST_BUFF_SEG	DW	00

FILE_NAME	DB	'A:TESTSCRN.PIC',0	;CHANGE THIS TO YOUR FILENAME

WORK_AREA	ENDS

CSEG		SEGMENT	PARA PUBLIC 'CODE'

	ASSUME CS:CSEG,DS:WORK_AREA,SS:STACK

START		PROC	FAR

		PUSH	DS
		SUB	AX,AX
		PUSH	AX

		MOV	AX,WORK_AREA
		MOV	DS,AX

		CALL	SET_SCRN_MODE
		CALL	GET_SCREEN
		CALL	LOAD_SCREEN
		CALL	SET_PALET

STOP_IT:	NOP
		NOP
		NOP
		JMP	STOP_IT

START		ENDP

GET_SCREEN	PROC

		MOV	AH,05H			;Interupt code for the
		INT	0EFH			;get destination buffer.

		MOV	DEST_BUFF_ADR,BX	;Destination buffer offset
		MOV	DEST_BUFF_SEG,ES	;Destination buffer segment.

		RET

GET_SCREEN	ENDP

LOAD_SCREEN	PROC

		MOV	DX,OFFSET	FILE_NAME	;THIS IS THE FILE NAME
		MOV	BX,OFFSET	PALET_BUFF	;TO LOAD ! ! ! ! !
		MOV	AX,SEG		PALET_BUFF
		MOV	ES,AX
		MOV	DI,DEST_BUFF_ADR
		MOV	SI,DEST_BUFF_SEG

		INT	0A0H				;MLI interupt vector
		JC	LOAD_ERROR			;Carry is set if
							;an error occures.
		RET

LOAD_ERROR:	RET

LOAD_SCREEN	ENDP

SET_PALET	PROC

		MOV	CX,16		;Move the whole pallette
		MOV	DX,0		;Start with color #0
		MOV	AX,SEG		PALET_BUFF
		MOV	ES,AX
		MOV	AX,OFFSET	PALET_BUFF
		MOV	AH,0AH				;Set palet code
		MOV	AL,0				;Border color = 0
		INT	0EFH

		RET

SET_PALET	ENDP

SET_SCRN_MODE	PROC

		MOV	AH,00		;Set screen mode code
		MOV	AL,2		;set to 320 X 200 X 4 

		INT	0EFH
		RET

SET_SCRN_MODE	ENDP

CSEG		ENDS

		END START



