;	RAMDISK.ASM	MS-DOS V2.0 RAM DISK PROGRAM
;	Mark DeSmet, 1984
;	J. Blair - Added Banner at load time

CODE	SEGMENT PARA PUBLIC 'CODE'
OPEN		EQU	3DH
CLOSE		EQU	3EH
READ		EQU	3FH
MSDOS		EQU	21H


FATSEC		EQU	4		;SECTORS PER FAT

IBM		EQU	21H		;INTERRUPT TO CALL IBM
COCODE		EQU	2		;CODE FOR CONSOLE OUTPUT
VIDEO		EQU	10H		;VIDEO INTERRUPT
TTY		EQU	14

SHR		EQU	0		;STATIC REQUEST START
SRH_LEN		EQU	13		;LENGTH
SRH_LEN_FLD	EQU	0		;LENGTH FIELD
SRH_UCB_FLD	EQU	1		;UNIT CODE FIELD
SRH_CCD_FLD	EQU	2		;COMMAND CODE FIELD
SRH_STA_FLD	EQU	3		;STATUS FIELD
SRH_RES_FLD	EQU	5		;RESERVED AREA FIELD

MD		EQU	SRH_LEN		;MEDIA BYTE
DTA		EQU	SRH_LEN+1	;DATA TRANSFER ADDRESS
COUNT		EQU	DTA+4
SSN		EQU	COUNT+2		;START SECTOR NUMBER

RET_BYTE	EQU	DTA		;RETURN BYTE

BPBA_PTR	EQU	COUNT		;POINTER TO BPB
;	INITIALIZE
UNITS		EQU	SRH_LEN
BR_ADDR_0	EQU	SRH_LEN+1
BR_ADDR_1	EQU	BR_ADDR_0+2
BPB_PTR_OFF	EQU	BR_ADDR_0+4
BPB_PTR_SEG	EQU	BPB_PTR_OFF+2

	ASSUME	CS:CODE
BEGIN:
;	DEVICE HEADER
NEXT_DEV	DD	-1
ATTRIBUTE	DW	2000H
STRATEGY	DW	DEV_STRATEGY
INTERRUPT	DW	DEV_INT
DEV_NAME	DB	1		;NUMBER OF DEVICES
		DB	7 DUP (?)

RH_OFF		DW	0		;REQUEST HEADER OFFSET
RH_SEG		DW	0		;SEGMENT


;	CURRENT INFORMATION

TOTAL		DW	0		;NUMBER OF SECTORS TO TRANSFER
START_SEC	DW	0		;FIRST SECTOR
VDISK_PTR	DW	0
USER_DTA	DD	0		;USERS DATA TRANSFER ADDRESS
BOOT_REC	DB	0,0,0		;JUMP
		DB	'RamDisk '
BPB		DW	512		;PER SECTOR
		DB	1		;ALLOCATION UNIT
		DW	1		;1 RESERVED
		DB	2		;2 FATS
		DW	64		;DIRECTORY ENTRIES
SECTORS		DW	650		;SECTORS TOTAL
		DB	0FCH		;MEDIA BYTE
		DW	FATSEC		;SECTORS IN FATS
BPB_PTR		DW	BPB


FUNTAB	LABEL	BYTE
	DW	INIT
	DW	MEDIA_CHECK
	DW	BUILD_BPB
	DW	EXIT
	DW	INPUT
	DW	EXIT
	DW	EXIT
	DW	EXIT
	DW	OUTPUT
	DW	OUTPUT			;DONT BOTHER VERIFYING
	DW	EXIT
	DW	EXIT
	DW	EXIT


IN_SAVE:MOV	AX,ES:WORD PTR DTA[BX]	;SAVE CALLERS DTA
	MOV	CS:WORD PTR USER_DTA,AX
	MOV	AX,ES:WORD PTR DTA+2[BX]
	MOV	CS:WORD PTR USER_DTA+2,AX
	MOV	AX,ES:WORD PTR SSN[BX]	;START SECTOR
	MOV	CS:START_SEC,AX
	MOV	AX,ES:WORD PTR COUNT[BX];COUNT OF SECTORS
	MOV	AH,0
	MOV	CS:TOTAL,AX
	RET

CALC_ADDR:
	MOV	AX,CS:START_SEC
	MOV	CL,5			;TURN SECTORS INTO PARAGRAPHS
	SHL	AX,CL
	ADD	AX,CS:VDISK_PTR
	MOV	DS,AX			;MOVE ADDRESS TO DS:SI
	XOR	SI,SI
	MOV	AX,CS:TOTAL		;CALC CX=LENGTH IN WORDS
	MOV	CL,8			;256 WORDS PER SECTOR
	SHL	AX,CL
	MOV	CX,AX			;WORD COUNT
	RET

;	STRATEGY ENTRY

DEV_STRATEGY	PROC	FAR
	MOV	CS:RH_SEG,ES		;SAVE ES:BX
	MOV	CS:RH_OFF,BX
	RET
DEV_STRATEGY	ENDP

;	DEVICE INTERRUPT HANDLER

DEV_INT	PROC	FAR
	PUSH	DS			;SAVE STATE
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
;		SET STATUS TO ALL OK AS NO ERRORS POSSABLE
	MOV	ES:WORD PTR SRH_STA_FLD[BX],100H
	MOV	AL,ES:[BX+2]		;GET FUNCTION BYTE
	SHL	AL,1			;TIMES 2
	MOV	AH,0
	MOV	DI,AX			;FUNCTION OFFSET
	JMP	WORD PTR CS:FUNTAB[DI]


;	INITIALIZATION

INIT:	MOV	AX,CS			;TINY CASE
	MOV	DS,AX
	PUSH	ES
	PUSH	BX


;  GET THE SPECIFIED SIZE. THE BPB POINTER FIELD HAS POINTER TO FIRST
;	BYTE AFTER = IN DEVICE=XXX

	LES	BX,ES:DWORD PTR BPB_PTR_OFF[BX]
NCH:	MOV	AL,ES:[BX]		;LOOK FOR A DIGIT BEFORE A LF
	CMP	AL,'0'
	JB	NOTDIG
	CMP	AL,'9'
	JBE	GETNUM
NOTDIG:	INC	BX			;NEED TO LOOK FOR MORE
	CMP	AL,10			;LF IF NOT
	JNZ	NCH
	MOV	CX,128			;128 k DEFAULT
	JMP	GOTSIZE

GETNUM:	MOV	CX,0			;TOTAL
NNUM:	MOV	DL,ES:[BX]		;NEXT DIGIT
	INC	BX
	SUB	DL,'0'
	CMP	DL,9
	JA	ENDNUM
	MOV	DH,0
	PUSH	DX
	MOV	AX,10
	MUL	CX
	POP	DX
	ADD	AX,DX
	MOV	CX,AX
	JMP	NNUM
ENDNUM:	CMP	CX,32			;32 K MINIMUM
	JAE	TEST650
	MOV	CX,32
TEST650:CMP	CX,650
	JB	GOTSIZE
	MOV	CX,650
GOTSIZE:SHL	CX,1			;2 SECTORS PER K
	MOV	SECTORS,CX
	POP	BX			;RETRIEVE BLOCK ADDRESS
	POP	ES
	
	PUSH	CS			;CALC START ADDRESS OF RAMDISK
	POP	DX
	MOV	AX,OFFSET VDISK		;RAM IS AT END OF THIS CODE
	MOV	CL,4			;MAKE PARAS
	SHR	AX,CL
	INC	AX			;1 FOR ROUND UP
	ADD	AX,DX			;BASE PARAGRAPH
	MOV	CS:VDISK_PTR,AX		;REMEMBER BASE
	MOV	DX,SECTORS		;CALC END ADDRESS
	MOV	CL,5			;GET SECTORS OF RAM DISK
	SHL	DX,CL
	ADD	AX,DX			;NEXT FREE BYTE
	MOV	ES:WORD PTR BR_ADDR_0[BX],0 ;SET FREE ADDRESS
	MOV	ES:WORD PTR BR_ADDR_1[BX],AX
	MOV	ES:BYTE PTR UNITS[BX],1	;ONE UNIT
	MOV	ES:WORD PTR BPB_PTR_OFF[BX],OFFSET BPB_PTR
	MOV	ES:BPB_PTR_SEG[BX],CS

	MOV	ES,CS:VDISK_PTR		;SET BOOT RECORD
	XOR	DI,DI
	PUSH	CS			;SET DS:SI TO BOOT IMAGE
	POP	DS
	MOV	SI,OFFSET BOOT_REC
	CLD
	MOV	CX,24			;LENGTH OF BOOT
REP	MOVSB
	MOV	DI,512			;ZERO OUT FAT
	MOV	AL,0FCH			;SET FIRST 3 BYTES OF FAT
	STOSB
	MOV	AX,0FFFFH
	STOSW
	MOV	CX,FATSEC*512-3		;SIZE OF REST OF FAT
	XOR	AL,AL
REP	STOSB				;FAT IS ZERO
	PUSH	ES
	POP	DS
	MOV	SI,DI			;MAKE SECOND COPY OF FAT
	SUB	SI,FATSEC*512
	MOV	CX,FATSEC*256
REP	MOVSW
	XOR	AX,AX			;ZERO DIRECTORY
	MOV	CX,256*6
REP	STOSW

;Put actual kb allocated into banner message
	mov	ax,sectors		;sectors = kb * 2
	shr	ax,1			;ax now has kb (32 .le. kb .le. 650)
	mov	bx,10			;divisor
	mov	si,offset dig1		;point to units digit
looop:	xor	dx,dx			;clear dx before divide
	idiv	bx			;ax = ax/10, dx = remainder
	add	dl,'0'			;change	remainder to ascii
	mov	byte ptr cs:[si],dl	;put it in banner
	dec	si			;point to next digit in banner
	or	ax,ax			;anything left in ax?
	jnz	looop			;yes-jump

;Print the banner
	mov	ax,cs
	mov	ds,ax
	mov	ah,9			;dos print string
	mov	dx,offset banner	;ds:dx points to '$' terminated string
	int	21h

	JMP	EXIT

BANNER	LABEL	BYTE
	DB	13,10,'->   '
DIG1	DB	' '
	DB	'kb RamDisk Installed (V1.00)',13,10,'$'


;	MEDIA CHECK

	DB	'MEDIA CHECK'
MEDIA_CHECK:
	MOV	ES:BYTE PTR RET_BYTE[BX],1
	JMP	EXIT


;	BUILD BIOS PARAMETER BLOCK

	DB	'BUILD BPB'
BUILD_BPB:
	MOV	ES:WORD PTR BPBA_PTR[BX],OFFSET BPB
	MOV	ES:WORD PTR BPBA_PTR+2[BX],CS
	JMP	EXIT



;	READ A SECTOR

	DB	'INPUT'
INPUT:
	CALL	IN_SAVE
	CALL	CALC_ADDR		;GET SECTOR ADDRESS
	LES	DI,CS:USER_DTA		;LOAD DESTINATION ADDRESS
	CLD
REP	MOVSW				;MOVE READ DATA
	JMP	EXIT

;	WRITE A SECTOR

	DB	'OUTPUT'
OUTPUT:
	CALL	IN_SAVE
	CALL	CALC_ADDR		;GET DESTINATION ADDRESS
	PUSH	DS
	POP	ES			;PUT DESTINATION INTO ES:DI
	MOV	DI,SI
	LDS	SI,CS:USER_DTA		;LOAD SOURCE ADDRESS
	CLD
REP	MOVSW
	JMP	EXIT


;	COMMON EXIT

EXIT:	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	ES
	POP	DS
	RET
DEV_INT	ENDP
VDISK	EQU	$
CODE	ENDS
	END	BEGIN
