// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Database related functions for ActiveSync examples
#include "stdafx.h"
#include "db.h"

CEOID g_oidDataBase;	// Object Identifier of our database

// returns the OID of the given database name
CEOID ASGetDBOID(LPTSTR lpDbName)
{
	CEOID dbOid = 0;
	HANDLE hDB;

	// open the database to get the OID
	if((hDB = CeOpenDatabase(&dbOid, lpDbName, 0, 0, NULL)) == INVALID_HANDLE_VALUE)
		return 0;
	else
	{
		// Close database, and return OID
		CloseHandle(hDB);
		return dbOid;
	}
}

// ASRecInDB returns true if record is in our database
BOOL ASRecInDB(CEOID oidDatabase, CEOID oidRecord)
{
	CEOIDINFO  oidInfo;
	if(!CeOidGetInfo(oidRecord, &oidInfo))
		return FALSE;
	return (oidInfo.infRecord.oidParent == oidDatabase);
}

// Takes the given record in the database and returns it as a string
BOOL ASSerialiseRecord(CEOID oidRec, LPBYTE* lpByte, DWORD* dwByte)
{
	CEOID ceoidRec, dbOid = 0;
	DWORD dwBuf, dwIndex;
	CEPROPVAL *props = NULL;
	unsigned short lProps = 0;
	HANDLE hDB;

	// open the database to get the OID
	if((hDB = CeOpenDatabase(&dbOid, DB_NAME, 0, 0, NULL)) == INVALID_HANDLE_VALUE)
		return FALSE;
	else
	{
		// Locate the record in the database
		if(!CeSeekDatabase(hDB, CEDB_SEEK_CEOID, oidRec, &dwIndex))
		{
			// close database and return failure
			CloseHandle(hDB);
			return FALSE;
		}
		// now read the record

		ceoidRec = CeReadRecordPropsEx(hDB, 
				CEDB_ALLOWREALLOC, 
				&lProps,
				NULL,
				(LPBYTE*)&props,
				&dwBuf,
				NULL);
		if(ceoidRec == 0)
		{
			CloseHandle(hDB);
			return FALSE;
		}
		// extract out the three properties we're interested in
		NOTE* lpNote = new NOTE;
		for(int i = 0; i < lProps; i++)
		{
			switch(props[i].propid)
			{
				case MAKELONG(CEVT_FILETIME, PROP_DATEADDED):
					lpNote->ftOriginal = props[i].val.filetime;
					break;
				case MAKELONG(CEVT_LPWSTR, PROP_NOTE):
					wcscpy(lpNote->szNote, props[i].val.lpwstr);
					break;
				case MAKELONG(CEVT_FILETIME, PROP_MODIFIED):
					lpNote->ftLastUpdate = props[i].val.filetime;
					break;
			}
		}
		*lpByte = (LPBYTE)lpNote;
		*dwByte = sizeof(NOTE);
		CloseHandle(hDB);
		return TRUE;
	}
}

// takes the timestamp and note string and writes out a new record or updates existing record
CEOID ASDeserializeRecord(FILETIME* ftOriginal, FILETIME* ftModified, LPTSTR szNote, 
						  DWORD dwNoteLen, BOOL bNewRecord, CEOID oidRecord)
{
	CEPROPVAL rgProps[3];
	HANDLE hDB;
	CEOID oidNewRec, dbOid = 0;

	// open the database to get the OID
	if((hDB = CeOpenDatabase(&dbOid, DB_NAME, 0, 0, NULL)) == INVALID_HANDLE_VALUE)
	{
		MessageBox(NULL, _T("Could not open database"), NULL, 0);
		return FALSE;
	}

	// update properties structure
	rgProps[0].propid = MAKELONG(CEVT_FILETIME, PROP_DATEADDED);
	rgProps[0].wFlags = 0;
	rgProps[0].val.filetime = *ftOriginal;
	rgProps[1].propid = MAKELONG(CEVT_LPWSTR, PROP_NOTE);
	rgProps[1].wFlags = 0;
	rgProps[1].val.lpwstr = szNote;
	rgProps[2].propid = MAKELONG(CEVT_FILETIME, PROP_MODIFIED);
	rgProps[2].wFlags = 0;
	rgProps[2].val.filetime = *ftModified;

	if(bNewRecord)
	{
		oidRecord = 0;
	}

	oidNewRec = CeWriteRecordProps(hDB, oidRecord, 3, rgProps);
	if(oidNewRec == 0)
		MessageBox(NULL, _T("Could not write record"), NULL, 0);

	CloseHandle(hDB);
	return oidNewRec;
}

// deletes the record with the given CEOID
BOOL ASDeleteRecord(CEOID recToDelete)
{
	HANDLE hDB;
	CEOID dbOid = 0;

	if((hDB = CeOpenDatabase(&dbOid, DB_NAME, 0, 0, NULL)) == INVALID_HANDLE_VALUE)
		return FALSE;
	if(!CeDeleteRecord(hDB, recToDelete))
	{
		CloseHandle(hDB);
		return FALSE;
	}
	CloseHandle(hDB);
	return TRUE;
}

