// cldeviceDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cldevice.h"
#include "cldeviceDlg.h"
#include "NoteDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCldeviceDlg dialog

CCldeviceDlg::CCldeviceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCldeviceDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCldeviceDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCldeviceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCldeviceDlg)
	DDX_Control(pDX, IDC_NOTES, m_lvNotes);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCldeviceDlg, CDialog)
	//{{AFX_MSG_MAP(CCldeviceDlg)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_BN_CLICKED(IDC_UPDATE, OnUpdate)
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_BN_CLICKED(IDC_DELETEALL, OnDeleteall)
	ON_BN_CLICKED(IDC_REGISTER, OnRegister)
	//}}AFX_MSG_MAP
	ON_MESSAGE(DB_CEOID_CHANGED, OnDBChange)
	ON_MESSAGE(DB_CEOID_CREATED, OnDBChange)
	ON_MESSAGE(DB_CEOID_RECORD_DELETED, OnDBChange)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCldeviceDlg message handlers

BOOL CCldeviceDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	static TCHAR* szHeader[] = { _T("Date Added"), _T("Note")};

	static int nWidths[] = { 160, 200};

	LVCOLUMN lvc;
	lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	lvc.fmt = LVCFMT_LEFT;

	for(int nField = 0; nField < 2; nField++)
	{
		lvc.pszText = szHeader[nField];
		lvc.iSubItem = nField;
		lvc.cx = nWidths[nField];
		m_lvNotes.InsertColumn(nField, &lvc);
	}
	// create database if it doesn't exist, otherwise open it
	m_dbList.OpenCreateDatabase(this);
	m_dbList.ListNotes(m_lvNotes);
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CCldeviceDlg::OnAdd() 
{
	CNoteDlg dlg;
	dlg.m_bAdd = TRUE;
	if(dlg.DoModal() == IDOK)
	{
		m_dbList.AddNote(dlg.m_sNote);
		m_dbList.ListNotes(m_lvNotes);
	}
}

void CCldeviceDlg::OnDelete() 
{
	CString sNoteTime = m_lvNotes.GetItemText(m_lvNotes.GetSelectionMark(), 0);
	
	if(sNoteTime == _T(""))
	{
		AfxMessageBox(_T("Please select a Note to Delete!"));
		return;
	}
	m_dbList.DeleteNote(sNoteTime);
	m_dbList.ListNotes(m_lvNotes);
}

void CCldeviceDlg::OnUpdate() 
{
	CNoteDlg dlg;

	CString sNoteTime = m_lvNotes.GetItemText(m_lvNotes.GetSelectionMark(), 0);
	if(sNoteTime == _T(""))
	{
		AfxMessageBox(_T("Please select a Note to Update!"));
		return;
	}
	
	dlg.m_bAdd = FALSE;
	dlg.m_sNote = m_lvNotes.GetItemText(m_lvNotes.GetSelectionMark(), 1);

	if(dlg.DoModal() == IDOK)
	{
		m_dbList.UpdateNote(sNoteTime, dlg.m_sNote);
		m_dbList.ListNotes(m_lvNotes);
	}
}

void CCldeviceDlg::OnExit() 
{
	PostQuitMessage(0);
}

void CCldeviceDlg::OnDeleteall() 
{
	m_dbList.DeleteAll();
	m_dbList.ListNotes(m_lvNotes);
}

typedef BOOL (CALLBACK *PFNREGISTER)();

// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Register DLL as an ActiveSync service
void CCldeviceDlg::OnRegister() 
{
	HINSTANCE hLib;

	hLib = LoadLibrary(_T("asdevice.dll"));
	if(hLib == NULL)
	{
		AfxMessageBox(_T("Could not find asdevice.dll"));
		return;
	}
	// now get address of exported register function
	PFNREGISTER pfnRegister = (PFNREGISTER)GetProcAddress(hLib, _T("RegisterActiveSync"));
	if(pfnRegister == NULL)
	{
		AfxMessageBox(_T("Could not find function RegisterActiveSync in asdevice.dll"));
		FreeLibrary(hLib);
		return;
	}
	// now call the function
	if(pfnRegister())
		AfxMessageBox(_T("Updated!"));
	else
		AfxMessageBox(_T("Could not update registry with information"));
	FreeLibrary(hLib);
	return;
}

LRESULT CCldeviceDlg::OnDBChange(WPARAM wParam, LPARAM lParam)
{
	m_dbList.ListNotes(m_lvNotes);
	return TRUE;
}
