// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// asdevice.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "ReplObjHandler.h"
#include "db.h"

// Global variables
UINT g_uPartnerBit;		// partner 1 or partner 2 (up to two ActiveSync partners)

// database defines

BOOL APIENTRY DllMain( HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
    return TRUE;
}

extern "C" BOOL _declspec(dllexport) RegisterActiveSync()
{
	// register this DLL as implementing an ActiveSync service
	HKEY hKey;
	DWORD dwDisp;

	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
					_T("Windows CE Services\\Synchronization\\Objects\\AsyncSample"),
					0, NULL, 0, 0, NULL,
					&hKey, &dwDisp) != 0)
		return FALSE;
	if(RegSetValueEx(hKey, _T("Store"), 
			NULL, 
			REG_SZ, 
			(LPBYTE)_T("asdevice.dll"), 
			13 * sizeof(TCHAR)) != 0)
		return FALSE;
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////
// ActiveSync exported functions

// InitobjType called when service is first loaded (lpszObjType != NULL) and when unloaded
// (lpszObjType == NULL);

extern "C" BOOL _declspec(dllexport) InitObjType(LPWSTR lpszObjType, 
							IReplObjHandler **ppObjHandler, UINT uPartnerBit)
{
    if ( lpszObjType == NULL )
    {
        // Terminates the device provider module and frees all
        // allocated resources.
        return TRUE;
    }
    // Allocate a new IReplObjHandler. 
    *ppObjHandler = new CDataHandler;
    // Save the uPartnerBit so that you can use it later on
	g_uPartnerBit = uPartnerBit;
	// Find Object Identifier of our database
	g_oidDataBase = ASGetDBOID(DB_NAME);
    return TRUE;
}

// Called by ActiveSync when an object has been changed or deleted 
// in the device object's store
extern "C" BOOL _declspec(dllexport) ObjectNotify(POBJNOTIFY pNotify)
{
    // Check to see if the structure size is the smaller (version control).
    if ( pNotify->cbStruct < sizeof( OBJNOTIFY ) )
	{
		 MessageBox(NULL, _T("ObjectNotify - incorrect version"), NULL, MB_OK);
         return FALSE;
	}
	// We're only interested in database record changes or clear change notifications
	if(!(pNotify->uFlags & (ONF_RECORD | ONF_CLEAR_CHANGE)))
		return FALSE;
	// For non-deleted records, check that the record is in our database
	if(!(pNotify->uFlags & ONF_DELETED))
	{
		if(!(pNotify->uFlags & ONF_RECORD))
			return FALSE;		// it's not actually a record, so ignore
		if(!ASRecInDB(g_oidDataBase, pNotify->oidObject))
			return FALSE;		// not in our database
	}
	// sets the oid of the object to be replicated
	pNotify->poid = (UINT*) &pNotify->oidObject;
	// if object is to be deleted, set the number of objects to be deleted 
	if(pNotify->uFlags & ONF_DELETED)
		pNotify->cOidDel = 1;	
	else
		pNotify->cOidChg = 1;
    return TRUE;
}

// GetObjTypeInfo is called by the service when sync'ing database records. We return
// Information about our database

extern "C" BOOL _declspec(dllexport) GetObjTypeInfo(POBJTYPEINFO pInfo)
{
	CEOIDINFO oidInfo;
	// Check versioning of the structure
	if ( pInfo->cbStruct < sizeof( OBJTYPEINFO ) )
	{
		MessageBox(NULL, _T("GetObjTypeInfo called - wrong version"), NULL, MB_OK);
		return FALSE;
	}
    // Clear the structure.
    memset( &(oidInfo), 0, sizeof(oidInfo));
    // Retrieves information about the object in the object store.
	CeOidGetInfo( g_oidDataBase, &oidInfo );
    // Store the database information into the OBJTYPEINFO structure.
	wcscpy( pInfo->szName, oidInfo.infDatabase.szDbaseName );
    pInfo->cObjects = oidInfo.infDatabase.wNumRecords;
	pInfo->cbAllObj = oidInfo.infDatabase.dwSize;
	pInfo->ftLastModified = oidInfo.infDatabase.ftLastModified;
    return TRUE;
}
