// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CDataHandler: Class to implement IReplObjHandler for serialize/deserialize object

#include "stdafx.h"
#include "db.h"

#include "ReplObjHandler.h"

////////////////////////////////////////////////////////////////////////////////
// Construction/Destruction implementation

CDataHandler::CDataHandler()
{
	m_cRef = 1;
	m_pReadSetup = NULL;
	m_pWriteSetup = NULL;
}

CDataHandler::~CDataHandler()
{
}

////////////////////////////////////////////////////////////////////////////////
// IUnknown implementation

STDMETHODIMP_(ULONG) CDataHandler::AddRef()
{
	InterlockedIncrement(&m_cRef);
	return m_cRef;
}

STDMETHODIMP_(ULONG) CDataHandler::Release()
{
	if(InterlockedDecrement(&m_cRef) == 0)
		delete this;
	return m_cRef;
}

STDMETHODIMP CDataHandler::QueryInterface(REFIID iid, void ** ppvObject)
{
	*ppvObject = NULL;
	return E_NOINTERFACE;		// no other interfaces are supported
}

////////////////////////////////////////////////////////////////////////////////
// IReplObjHandler implementation

// Called to initialize transfer of an object
STDMETHODIMP CDataHandler::Setup(PREPLSETUP pSetup)
{
	// Can be reading and writing at the same time, so need
	// two setups
	if(pSetup->fRead)
		m_pReadSetup = pSetup;
	else
		m_pWriteSetup = pSetup;
	return NOERROR;
}

// Called to allow any resources to be freed after serialization/deserialization
STDMETHODIMP CDataHandler::Reset(PREPLSETUP pSetup)
{
	return NOERROR;	// no resources to be freed
}

// Serializes object into one or more packets. In this case, a single packet is returned
STDMETHODIMP CDataHandler::GetPacket(LPBYTE *lppbData, DWORD *pcbData, DWORD cbRecommend)
{
	HRESULT hr = RWRN_LAST_PACKET;
	LPBYTE lpByte;
	DWORD dwLen;

	if(!ASSerialiseRecord(m_pReadSetup->oid, &lpByte, &dwLen))
		hr = RERR_BAD_OBJECT;
	else
	{
		*lppbData = lpByte;
		*pcbData = dwLen;
	}
	return hr;
}

// Deserializes object and writes/updates record in database
STDMETHODIMP CDataHandler::SetPacket(LPBYTE lpbData, DWORD cbData)
{
	NOTE* aNote;

	CEOID oidNewRec;
	BOOL bNewRec;

	aNote = (NOTE*)lpbData;
	
	bNewRec = m_pWriteSetup->dwFlags & RSF_NEW_OBJECT;

	if((oidNewRec = ASDeserializeRecord(&aNote->ftOriginal, &aNote->ftLastUpdate, 
						aNote->szNote, wcslen(aNote->szNote), 
						bNewRec, m_pWriteSetup->oid)) == 0)
		return RERR_SKIP_ALL;
	else
	{
		m_pWriteSetup->oidNew = oidNewRec;
		return NOERROR;
	}
}

// synchronized object needs to be deleted

STDMETHODIMP CDataHandler::DeleteObj(PREPLSETUP pSetup)
{
	if(ASDeleteRecord(pSetup->oid))
		return NOERROR;
	else
		return E_UNEXPECTED;
}


