// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Factory.cpp - implementation of IFactory interface class

#include "stdafx.h"
#include "component.h"

LONG g_nServerLocks;

// Implement standard IUnknown members for class factory
HRESULT __stdcall CFactory::QueryInterface(const IID& iid, void** ppv)
{
	if(iid == IID_IUnknown || iid == IID_IClassFactory)
		*ppv = (IClassFactory*)(this);
	else
	{
		*ppv = NULL;
		return E_NOINTERFACE;
	}
	((IUnknown*)(*ppv))->AddRef();
	return S_OK;
}

ULONG __stdcall CFactory::AddRef()
{
	return InterlockedIncrement(&m_nRef);
}

ULONG __stdcall CFactory::Release()
{
	if(InterlockedDecrement(&m_nRef) == 0)
	{
		delete this;
		return 0;
	}
	return m_nRef;
}

// Constructor/Destructor for Class Factory 
CFactory::CFactory() : m_nRef(0)
{
}

CFactory::~CFactory() 
{
}

// Create instance of the component
HRESULT __stdcall CFactory::CreateInstance(IUnknown* pUnknownOuter,
			const IID& iid, void **ppv)
{
	// this component cannot aggregate
	if(pUnknownOuter != NULL)
		return CLASS_E_NOAGGREGATION;
	// Create the component
	// TODO: Change the class names here to the component class, and perform
	//       any necessary intialization
	CActiveSyncEg* pComponent = new CActiveSyncEg;
	if(pComponent == NULL)
		return E_OUTOFMEMORY;
	// get the requested interface
	HRESULT hr = pComponent->QueryInterface(iid, ppv);
	if(!SUCCEEDED(hr))
		pComponent->Release();	// component will delete itself.
	return hr;
}

// Lock/unlock server (DLL) at client's request
HRESULT __stdcall CFactory::LockServer(BOOL bLock)
{
	if(bLock)
		InterlockedIncrement(&g_nServerLocks);
	else
		InterlockedDecrement(&g_nServerLocks);
	return S_OK;
}
