// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// ClDesktopDlg.cpp : implementation file
//

#include "stdafx.h"
#include "clDesktop.h"
#include "clDesktopDlg.h"
#include "notedlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClDesktopDlg dialog

CClDesktopDlg::CClDesktopDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CClDesktopDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CClDesktopDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CClDesktopDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CClDesktopDlg)
	DDX_Control(pDX, IDC_NOTES, m_lvNotes);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CClDesktopDlg, CDialog)
	//{{AFX_MSG_MAP(CClDesktopDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_BN_CLICKED(IDC_DELETEALL, OnDeleteall)
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_BN_CLICKED(IDC_UPDATE, OnUpdate)
	ON_BN_CLICKED(IDC_REFRESH, OnRefresh)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClDesktopDlg message handlers

BOOL CClDesktopDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	static TCHAR* szHeader[] = { _T("Date Added"), _T("Note")};

	static int nWidths[] = { 160, 200};

	LVCOLUMN lvc;
	lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	lvc.fmt = LVCFMT_LEFT;

	for(int nField = 0; nField < 2; nField++)
	{
		lvc.pszText = szHeader[nField];
		lvc.iSubItem = nField;
		lvc.cx = nWidths[nField];
		m_lvNotes.InsertColumn(nField, &lvc);
	}
	// create database if it doesn't exist, otherwise open it
	m_dbList.OpenCreateDatabase();
	m_dbList.ListNotes(m_lvNotes);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CClDesktopDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CClDesktopDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CClDesktopDlg::OnAdd() 
{
	CNoteDlg dlg;
	dlg.m_bAdd = TRUE;
	if(dlg.DoModal() == IDOK)
	{
		m_dbList.AddNote(dlg.m_sNote);
		m_dbList.ListNotes(m_lvNotes);
	}
}

void CClDesktopDlg::OnDelete() 
{
	CString sNoteTime = m_lvNotes.GetItemText(m_lvNotes.GetSelectionMark(), 0);
	
	if(sNoteTime == _T(""))
	{
		AfxMessageBox(_T("Please select a Note to Delete!"));
		return;
	}
	m_dbList.DeleteNote(sNoteTime);
	m_dbList.ListNotes(m_lvNotes);
}

void CClDesktopDlg::OnDeleteall() 
{
	m_dbList.DeleteAll();
	m_dbList.ListNotes(m_lvNotes);
}

// exit the application
void CClDesktopDlg::OnExit() 
{
	PostQuitMessage(0);	
}

void CClDesktopDlg::OnUpdate() 
{
	CNoteDlg dlg;

	CString sNoteTime = m_lvNotes.GetItemText(m_lvNotes.GetSelectionMark(), 0);
	if(sNoteTime == _T(""))
	{
		AfxMessageBox(_T("Please select a Note to Update!"));
		return;
	}
	
	dlg.m_bAdd = FALSE;
	dlg.m_sNote = m_lvNotes.GetItemText(m_lvNotes.GetSelectionMark(), 1);

	if(dlg.DoModal() == IDOK)
	{
		m_dbList.UpdateNote(sNoteTime, dlg.m_sNote);
		m_dbList.ListNotes(m_lvNotes);
	}
}

void CClDesktopDlg::OnRefresh() 
{
	m_dbList.ListNotes(m_lvNotes);
}
