// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CDataHandler: Class to implement IReplObjHandler for serialize/deserialize object

class CDataHandler : public IReplObjHandler
{
public:
	CDataHandler();
	~CDataHandler();

	// IUknown methods
	STDMETHODIMP_(ULONG) AddRef();
	STDMETHODIMP_(ULONG) Release();
	STDMETHODIMP QueryInterface(REFIID iid, void ** ppvObject);

	// IReplObjHandler methods
	STDMETHODIMP Setup(PREPLSETUP pSetup);
	STDMETHODIMP Reset(PREPLSETUP pSetup);
	STDMETHODIMP GetPacket( LPBYTE *lppbData, DWORD *pcbData, DWORD cbRecommend);
	STDMETHODIMP SetPacket(LPBYTE lpbData, DWORD cbData);
	STDMETHODIMP DeleteObj(PREPLSETUP pSetup);

	void SetDatabase(CListDB*);
private:
	long m_cRef;
	PREPLSETUP m_pWriteSetup, m_pReadSetup;
	CListDB* m_pListDB;
};
