// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// DLL Functions for component

#include "stdafx.h"

#include "component.h"

HRESULT RegisterActiveSync();		// for registering ActiveSync Registry entries

const LPTSTR g_szFriendlyName = _T("ActiveSync Example");
const LPTSTR g_szVerIndProgID = _T("Asdesktop.ActiveSyncEg");
const LPTSTR g_szProgID = _T("Asdesktop.ActiveSyncEg.1");
const LPTSTR g_szStoreFile = _T("\\ActiveSynNotes.dat");

//////////////////////////////////////////////////////////////////////////////
// DLL FUNCTIONS:

HINSTANCE g_hModule = NULL ;   // DLL module instance

// Standard DLL entry point. Save module handle for future use
BOOL APIENTRY DllMain(HINSTANCE hModule, DWORD dwReason,
                      void* lpReserved)
{
	if (dwReason == DLL_PROCESS_ATTACH)
		g_hModule = hModule;
	return TRUE;
}

// register COM component
STDAPI DllRegisterServer()
{
	HRESULT hr = RegisterActiveSync();
	if(hr != S_OK)
		return hr;

	return RegisterServer(g_hModule, 
	    CLSID_ActiveSyncEg, g_szFriendlyName,
	    g_szVerIndProgID, g_szProgID);
}

// unregister COM component
STDAPI DllUnregisterServer()
{
	return UnregisterServer(CLSID_ActiveSyncEg,
	     g_szVerIndProgID, g_szProgID);
}

// Called by COM to determine if this DLL is in use (i.e. has components, or is currently
// locked by IClassFactory)
STDAPI DllCanUnloadNow()
{
	if(g_nComponents == 0 && g_nServerLocks == 0)
		return S_OK;
	else
		return S_FALSE;
}

// Called by COM to get a IClassFactory pointer for the component
STDAPI DllGetClassObject(REFCLSID clsid,
							REFIID iid, LPVOID* ppv)
{
	if(clsid != CLSID_ActiveSyncEg)
		return CLASS_E_CLASSNOTAVAILABLE;
	CFactory *pFactory = new CFactory;
	if(pFactory == NULL)
		return E_OUTOFMEMORY;
	// get requested interface
	HRESULT hr = pFactory->QueryInterface(iid, ppv);
	return hr;
}

HRESULT RegisterActiveSync()
{
	// Register as an ActiveSyn service provider
	HKEY hKey;
	DWORD dwDisp;
	static TCHAR szDescription[] = _T("ActiveSync Example Provider");
	static TCHAR szDisplayName[] = _T("TestNote");
	static TCHAR szPluralName[] = _T("TestNotes");
	static TCHAR szStore[] = _T("Asdesktop.ActiveSyncEg");

	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
				_T("Software\\Microsoft\\Windows CE Services\\Services\\Synchronization\\Objects\\AsyncSample"),
				0, 
				NULL, 
				0, 
				KEY_WRITE,				// desired security access
				NULL,					// security attributes
				&hKey, &dwDisp) != ERROR_SUCCESS)
	{
		MessageBox(NULL, _T("Could not open key"), NULL, MB_OK);
		return E_UNEXPECTED;
	}
	if(RegSetValueEx(hKey, _T(""),			// default value - name of service
			NULL, 
			REG_SZ, 
			(LPBYTE)szDescription, 
			_tcslen(szDescription) * sizeof(TCHAR)) != ERROR_SUCCESS)
	{
		MessageBox(NULL, _T("Could not write default string"), NULL, MB_OK);
		return E_UNEXPECTED;
	}
	if(RegSetValueEx(hKey, _T("Display Name"), 
			NULL, 
			REG_SZ, 
			(LPBYTE)szDisplayName, 
			 _tcslen(szDisplayName) * sizeof(TCHAR)) != ERROR_SUCCESS)
	{
		MessageBox(NULL, _T("Could not write display name"), NULL, MB_OK);
		return E_UNEXPECTED;
	}
	if(RegSetValueEx(hKey, _T("Plural Name"), 
			NULL, 
			REG_SZ, 
			(LPBYTE)szPluralName, 
			 _tcslen(szPluralName) * sizeof(TCHAR)) != ERROR_SUCCESS)
	{
		MessageBox(NULL, _T("Could not write plural name"), NULL, MB_OK);
		return E_UNEXPECTED;
	}
	if(RegSetValueEx(hKey, _T("Store"), 
			NULL, 
			REG_SZ, 
			(LPBYTE)szStore, 
			_tcslen(szStore) * sizeof(TCHAR)) != ERROR_SUCCESS)
	{
		MessageBox(NULL, _T("Could not write store name"), NULL, MB_OK);
		return E_UNEXPECTED;
	}
	DWORD dwDisabled = 0;
	if(RegSetValueEx(hKey, _T("Disabled"), 
			NULL, 
			REG_DWORD, 
			(LPBYTE) &dwDisabled, 
			 sizeof(DWORD)) != ERROR_SUCCESS)
	{
		MessageBox(NULL, _T("Could not write disabled status"), NULL, MB_OK);
		return E_UNEXPECTED;
	}
	return S_OK;
}
