// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CEStream.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
// RAPI.H May be located in C:\Windows CE Tools\wce300\MS Pocket PC\support\ActiveSync\inc
#include <rapi.h>
// Function prototype to export function.
extern "C"
{
__declspec(dllexport) int ThreadTimes(DWORD cbInput, BYTE* pInput, DWORD *pcbOutput, BYTE **ppOutput, IRAPIStream *pStream);
}

const DWORD dwCODE_ERROR = 1;
const DWORD dwCODE_USERTIME = 2;
const DWORD dwCODE_END = 3;

BOOL WriteResult(DWORD dwCode, void* pData, DWORD dwBytesToWrite, IRAPIStream *pStream)
{
	DWORD dwWritten, dwToWrite, dwError;
	HRESULT hr;

	dwToWrite = sizeof(DWORD);
	hr = pStream->Write(&dwCode, dwToWrite, &dwWritten);
	if(FAILED(hr) || dwToWrite != dwWritten)
		return FALSE;

	if(dwBytesToWrite > 0)
	{
		dwError = GetLastError();
		hr = pStream->Write(pData, dwBytesToWrite, &dwWritten);
		if(FAILED(hr) || dwBytesToWrite != dwWritten)
			return FALSE;
	}
	return TRUE;
}

int ThreadTimes(DWORD cbInput, BYTE* pInput, DWORD *pcbOutput, BYTE **ppOutput, IRAPIStream *pStream)
{
	LPTSTR lpAppName = (LPTSTR)pInput;
	PROCESS_INFORMATION pi;
	FILETIME ft[4]; 
	DWORD dwError;
	BOOL bContinue = TRUE;
 
	if(!CreateProcess(lpAppName, NULL, NULL, NULL, FALSE,0, NULL, NULL, NULL, &pi))
	{
		dwError = GetLastError();
		WriteResult(dwCODE_ERROR, &dwError, sizeof(dwError), pStream);
	}
	else
	{
		while(bContinue && WaitForSingleObject(pi.hProcess, 5000) == WAIT_TIMEOUT)
		{
			if(!GetThreadTimes(pi.hThread, &ft[0], &ft[1], &ft[2], &ft[3]))
			{
				dwError = GetLastError();
				WriteResult(dwCODE_ERROR, &dwError, sizeof(dwError), pStream);
				bContinue = FALSE;
			}
			else 
			{
				if(!WriteResult(dwCODE_USERTIME, ft, sizeof(ft), pStream))
					bContinue = FALSE;
			}
		}
		if(bContinue)
			WriteResult(dwCODE_END, NULL, 0, pStream);
	}
	CloseHandle(pi.hProcess);
	CloseHandle(pi.hThread);
	// no output data to send back
	*ppOutput = NULL;
	*pcbOutput = 0;
	return 0;
}

