// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CreateProcess.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <iostream.h>
#include <rapi.h>

// Include rapi.lib into the project

// WARNING: Remove  #define WIN32_LEAN_AND_MEAN from stdafx.h!

void ShowRAPIError()
{
	int nErr = CeRapiGetError();
	if(nErr == 0)
		cout << "Win32 Error:" 
				<< GetLastError() << endl;
	else
		cout << "RAPI Error:"
				<< nErr << endl;
}

int main(int argc, char* argv[])
{
	RAPIINIT rapiInit;
	HRESULT hr;
	DWORD dwWaitResult;

	rapiInit.cbSize = sizeof(RAPIINIT);

	hr = CeRapiInitEx(&rapiInit);
	if(FAILED(hr))
	{
		cout << "Could not initialize RAPI:" << GetLastError() << endl;
		return 1;
	}
	dwWaitResult = WaitForSingleObject(rapiInit.heRapiInit, 10000);

	if(dwWaitResult == WAIT_FAILED)
	{
		cout << "Could not wait on event:" << GetLastError() << endl;
		return 1;
	}
	if(dwWaitResult == WAIT_TIMEOUT)
	{
		cout << "Could not connect to Windows CE Device" << endl;
		return 1;
	}
	if(FAILED(rapiInit.hrRapiInit))
	{
		ShowRAPIError();
		return 1;
	}
	PROCESS_INFORMATION pi;

	if(!CeCreateProcess(L"\\windows\\cmd.exe", NULL, NULL, NULL, 
			FALSE,0, NULL, NULL, NULL, &pi))
		ShowRAPIError();
	else 
	{
		if(WaitForSingleObject(pi.hProcess, INFINITE) == WAIT_FAILED)
			cout << "Wait Failed" << endl;
		if(!CeCloseHandle(pi.hProcess))
			ShowRAPIError();
		if(!CeCloseHandle(pi.hThread))
			ShowRAPIError();
	}
	hr = CeRapiUninit();
	if(FAILED(hr))
		cout << "Could not un-initialize RAPI" << endl;
	return 0;
}

