// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 16: ADO/CE, OLEDB and SQL Server

#include "stdafx.h"
#include "examples.h"

#include <comdef.h>

void _com_issue_errorex(HRESULT hr, IUnknown* pUnkn, REFIID riid)
{
//	cout << _T("COM Error in _com_issue_errorex: ") << hr << endl;
	RaiseException(hr, 0, 1, NULL);
}

_COM_SMARTPTR_TYPEDEF(IUnknown, __uuidof(IUnknown));

#import "adoce31.tlb" rename ("EOF", "A_EOF") rename_namespace ("AdoNS")
#import "adoxce31.tlb" rename ("EOF", "A_EOF") rename_namespace ("AdoXNS")

const LPTSTR lpConnection =
	_T("Provider=Microsoft.SQLServer.OLEDB.CE.1.0;Data Source=\\eVCADO.db");

// *** Listing 16.1
//
// Create a database (Catalog)

void Listing16_1()
{
	AdoXNS::_CatalogPtr	pCatalog;
	HRESULT hr;

	hr = pCatalog.CreateInstance(_T("ADOXCE.Catalog"));
	if(FAILED(hr))
	{
		cout << _T("Could not create catalog object") << endl;
		return;
	}
	_bstr_t bstrConnection(lpConnection); 
	_variant_t varConnection;
	varConnection = pCatalog->Create(bstrConnection);
	if(varConnection.vt != VT_DISPATCH)
	{
		cout << _T("Could not create catalog") << endl;
		return;
	}
	cout << _T("Database (Catalog) created") << endl;
}

// *** Listing 16.2
//
// Create a table

BOOL OpenCatalog(LPTSTR lpConnection, AdoXNS::_CatalogPtr &pCatalog)
{
	HRESULT hr;

	hr = pCatalog.CreateInstance(_T("ADOXCE.Catalog"));
	if(FAILED(hr))
	{
		cout << _T("Could not create catalog object") << endl;
		return FALSE;
	}
	_bstr_t bstrConnection(lpConnection); 
	_variant_t varConnection(bstrConnection);
	pCatalog->PutActiveConnection(varConnection);
	return TRUE;
}

BOOL AddColumn(AdoXNS::ColumnsPtr& pColumns, LPTSTR lpColName, 
				AdoXNS::DataTypeEnum dt, LONG lSize)
{
	HRESULT hr;
	_bstr_t bstrColumn(lpColName);
	_variant_t varColumn(bstrColumn); 
	hr = pColumns->Append(varColumn, dt, lSize);
	if(FAILED(hr))
	{
		cout << _T("Could not append column:") << lpColName << endl;
		return FALSE;
	}
	return TRUE;
}

void Listing16_2()
{
	AdoXNS::_CatalogPtr	pCatalog;

	AdoXNS::_TablePtr	pTable;
	AdoXNS::ColumnsPtr	pColumns;
	AdoXNS::_ColumnPtr	pColumn;
	AdoXNS::TablesPtr	pTables;
	HRESULT hr;

	if(!OpenCatalog(lpConnection, pCatalog))
		return;
	
	hr = pTable.CreateInstance(_T("ADOXCE.Table"));
	if(FAILED(hr))
	{
		cout << _T("Could not create table object") << endl;
		return;
	}
	// Create the table
	_bstr_t bstrTableName(_T("Customers"));
	pTable->Name = bstrTableName;

	// Retrieve the pointer to the column collection from the table object 
	pColumns = pTable->GetColumns();
	// Append the columns
	if(!AddColumn(pColumns, _T("CustName"), 
				AdoXNS::adVarWChar, 50))
		return;
	if(!AddColumn(pColumns, _T("CustNum"), 
				AdoXNS::adInteger, 4))
		return;
	if(!AddColumn(pColumns, _T("CustAddress"), 
				AdoXNS::adVarWChar, 1000))
		return;
	// Get a pointer to the tables collection
	pTables = pCatalog->GetTables();

	// Add the table to the DB
	_variant_t varTable((IDispatch*)pTable); // Type VT_DISPATCH
	hr = pTables->Append(varTable);
	if(FAILED(hr))
	{
		cout << _T("Could not append table") << endl;
		return;
	}
	cout << _T("Created") << endl;
}

// *** Listing 16.3
//
// List Tables

void Listing16_3()
{
	AdoXNS::_CatalogPtr	pCatalog;
	AdoXNS::TablesPtr	pTables;
	AdoXNS::_TablePtr	pTable;

	if(!OpenCatalog(lpConnection, pCatalog))
		return;
	// get collection of tables
	pTables = pCatalog->GetTables();
	// List tables
	cout << _T("Number of tables:") << pTables->Count << endl;
	for(short i = 0; i < pTables->Count; i++)
	{
		_variant_t vtIndex(i);
		pTable = pTables->Item[vtIndex];
		cout << _T("Table:") << (LPTSTR)pTable->Name << endl;
	}
}

// *** Listing 16.4
//
// Drop Table

void Listing16_4()
{
	AdoXNS::_CatalogPtr	pCatalog;
	AdoXNS::TablesPtr	pTables;
	AdoXNS::_TablePtr	pTable;

	HRESULT hr;

	if(!OpenCatalog(lpConnection, pCatalog))
		return;

	// get collection of tables
	pTables = pCatalog->GetTables();
	// Specify table to drop
	_bstr_t bstrTable(_T("Customers")); 
	_variant_t varTable(bstrTable);
	hr = pTables->Delete(varTable);
	if(FAILED(hr))
	{
		cout << _T("Could not drop table") << endl;
		return;
	}
	cout << _T("Table dropped") << endl;
}

// *** Listing 16.5
//
// Add Data Record

BOOL AddRecord(AdoNS::_RecordsetPtr& pRecordset, LPTSTR lpCustName, LONG lCustID, LPTSTR lpCustAddr)
{
	HRESULT hr;
	SAFEARRAYBOUND  bound[1];
	SAFEARRAY *		pColumns	= NULL;
	SAFEARRAY *		pData		= NULL;
	LONG lIndex = 0;
	BOOL bRet = TRUE;

	bound[0].lLbound = 0;
	bound[0].cElements = 3;
	pColumns = SafeArrayCreate(VT_VARIANT, 1, bound);
	pData = SafeArrayCreate(VT_VARIANT, 1, bound);
	if(pColumns == NULL || pData == NULL)
	{
		cout << _T("Could not create arrays.") << endl;
		return FALSE;
	}

	_variant_t varColumn(_T("CustName")); 
	SafeArrayPutElement(pColumns, &lIndex, &varColumn);
	lIndex++;
	varColumn = _T("CustNum"); 
	SafeArrayPutElement(pColumns, &lIndex, &varColumn);
	lIndex++;
	varColumn = _T("CustAddress"); 
	SafeArrayPutElement(pColumns, &lIndex, &varColumn);

	lIndex = 0;
	_variant_t varData(lpCustName); 
	SafeArrayPutElement(pData, &lIndex, &varData);
	lIndex++;
	varData = lCustID;
	SafeArrayPutElement(pData, &lIndex, &varData);
	lIndex++;
	varData = lpCustAddr;
	SafeArrayPutElement(pData, &lIndex, &varData);

	_variant_t varColumns; 
	varColumns.vt = VT_ARRAY | VT_VARIANT;
	varColumns.parray = pColumns;
	_variant_t varDataValues; 
	varDataValues.vt = VT_ARRAY | VT_VARIANT;
	varDataValues.parray = pData;

	hr = pRecordset->AddNew(varColumns, varDataValues);
	if(FAILED(hr))
	{
		cout << _T("Could not add new record to recordset") << endl;
		bRet = FALSE;
	}

	if(pColumns)
		SafeArrayDestroy(pColumns);
	if(pData)
		SafeArrayDestroy(pData);
	return bRet;
}

void Listing16_5()
{
	HRESULT hr;
	AdoNS::_RecordsetPtr pRecordset;

	// Get the base table rowset
	//
	hr = pRecordset.CreateInstance(_T("ADOCE.Recordset.3.1"));
	if(FAILED(hr))
	{
		cout << _T("Could not create recordset:") << hr << endl;
		return;
	}
	_bstr_t bstrConnection(lpConnection);
	_variant_t varConnection(bstrConnection); 
	_bstr_t bstrTable(_T("Customers"));
	_variant_t varTable(bstrTable); 

	cout << _T("About to open recordset") << endl;
	hr = pRecordset->Open(varTable,
						varConnection, 
						AdoNS::adOpenDynamic, 
						AdoNS::adLockOptimistic, 
						AdoNS::adCmdTableDirect);
	if(FAILED(hr))
	{
		cout << _T("Could not open recordset") << endl;
		return;
	}
	AddRecord(pRecordset, _T("Customer 1"), 1, _T("1500 Ocean View"));
	pRecordset->Close();

	cout << _T("New record added") << endl;
}

// *** Listing 16.6
//
// Retrieve Data

void DisplayFields(AdoNS::FieldsPtr & pFields)
{
	AdoNS::FieldPtr pField;
	_variant_t vValue;

	_bstr_t bstrIndex(_T("CustName"));
	_variant_t varIndex(bstrIndex); 
	pField = pFields->GetItem(varIndex);

	vValue = pField->GetValue();
	cout << _T("Customer: ") << vValue.bstrVal;
	
	bstrIndex = _T("CustNum");
	varIndex = bstrIndex;
	pField = pFields->GetItem(varIndex);
	vValue = pField->GetValue();
	cout << _T(" Num: ") << vValue.lVal;

	bstrIndex = _T("CustAddress");
	varIndex = bstrIndex;
	pField = pFields->GetItem(varIndex);
	vValue = pField->GetValue();
	cout << _T(" Addr: ") << vValue.bstrVal << endl;
}

void Listing16_6()
{
	HRESULT hr;
	AdoNS::_RecordsetPtr pRecordset;

	_bstr_t bstrConnection(lpConnection);
	_variant_t varConnection(bstrConnection); 
	_bstr_t bstrQuery(_T("Select * from Customers"));
	_variant_t varQuery(bstrQuery); 

	hr = pRecordset.CreateInstance(_T("ADOCE.Recordset.3.1"));
	if(FAILED(hr))
	{
		cout << _T("Could not create recordset:") << hr << endl;
		return;
	}
	// Open the base table and retrieve rows
	//
	cout << _T("About to open recordset") << endl;
	hr = pRecordset->Open(varQuery,
						varConnection, 
						AdoNS::adOpenStatic, 
						AdoNS::adLockReadOnly, 
						AdoNS::adCmdText);
	if(FAILED(hr))
	{
		cout << _T("Could not open recordset") << endl;
		return;
	}

	while(!pRecordset->GetA_EOF())
	{
		AdoNS::FieldsPtr pFields;
		pFields = pRecordset->GetFields();
		DisplayFields(pFields);
		pRecordset->MoveNext();
	}
	pRecordset->Close();
}

// *** Listing 16.7
//
// Connection Object 

BOOL GetConnection(AdoNS::_ConnectionPtr & pConnection)
{
	HRESULT hr;
	_bstr_t bstrConnection(lpConnection);
	_bstr_t bstrUserID(_T(""));
	_bstr_t bstrPassword(_T(""));

	hr = pConnection.CreateInstance(_T("ADOCE.Connection.3.1"));
	if(FAILED(hr))
	{
		cout << _T("Could not create connection:") << hr << endl;
		return FALSE;
	}
	hr = pConnection->Open(bstrConnection, 
					bstrUserID, bstrPassword, 0);
	if(FAILED(hr))
	{
		cout << _T("Could not create connection:") << hr << endl;
		return FALSE;
	}
	return TRUE;
}

void Listing16_7()
{
	AdoNS::_ConnectionPtr pConnection;
	if(!GetConnection(pConnection))
		return;
	
	_variant_t varRowsAffected;
	_bstr_t bstrSQL(_T("DELETE FROM Customers"));
	pConnection->Execute(bstrSQL, 
			&varRowsAffected, 
			AdoNS::adCmdText);
	cout << _T("Rows Deleted: ") << varRowsAffected.lVal << endl;

	pConnection->Close();
}

// *** Listing 16.8
//
// CREATE TABLE

void ExecuteSQL(AdoNS::_ConnectionPtr& pConnection,
					_bstr_t& bstrSQL)
{
	_variant_t varRowsAffected;
	pConnection->Execute(bstrSQL, 
			&varRowsAffected, 
			AdoNS::adCmdText);
}


void Listing16_8()
{
	AdoNS::_ConnectionPtr pConnection;
	if(!GetConnection(pConnection))
		return;
	_bstr_t bStrSQL(_T("CREATE TABLE Orders \
				(CustNum INT, OrderNum INT, \
				Description NCHAR VARYING(100), \
				DateAdded DATETIME)")); 
	ExecuteSQL(pConnection, bStrSQL);
	cout << _T("Table created") << endl;
	pConnection->Close();
}

// *** Listing 16.9
//
// DROP TABLE

void Listing16_9()
{
	AdoNS::_ConnectionPtr pConnection;
	if(!GetConnection(pConnection))
		return;
	_bstr_t bStrSQL(_T("DROP TABLE Orders ")); 
	ExecuteSQL(pConnection, bStrSQL);
	bStrSQL = _T("DROP TABLE OrderDetails "); 
	ExecuteSQL(pConnection, bStrSQL);
	pConnection->Close();
	cout << _T("Table Dropped") << endl;
}

// *** Listing 16.10
//
// CREATE TABLE with Identity

void Listing16_10()
{
	AdoNS::_ConnectionPtr pConnection;
	if(!GetConnection(pConnection))
		return;
	_bstr_t bStrSQL(_T("CREATE TABLE OrderDetails \
				(OrderDetailNum INT IDENTITY PRIMARY KEY, \
				OrderNum INT, \
				Product NCHAR VARYING(100), \
				Quantity INT)")); 
	ExecuteSQL(pConnection, bStrSQL);
	cout << _T("Table created") << endl;
	pConnection->Close();
}

// *** Listing 16.11
//
// CREATE INDEX

void Listing16_11()
{
	AdoNS::_ConnectionPtr pConnection;
	if(!GetConnection(pConnection))
		return;
	_bstr_t bStrSQL(_T("CREATE UNIQUE INDEX OrdersInd1 \
				ON Orders (OrderNum)")); 
	ExecuteSQL(pConnection, bStrSQL);
	bStrSQL = (_T("CREATE INDEX OrdersInd2 \
				ON Orders (CustNum)")); 
	ExecuteSQL(pConnection, bStrSQL);

	bStrSQL = (_T("CREATE UNIQUE INDEX Customers1 \
				ON Customers (CustNum)")); 
	ExecuteSQL(pConnection, bStrSQL);
	bStrSQL = (_T("CREATE UNIQUE INDEX Customers2 \
				ON Customers (CustName)")); 
	ExecuteSQL(pConnection, bStrSQL);

	cout << _T("Indexes created") << endl;
	pConnection->Close();

}

// *** Listing 16.12
//
// INSERT Statement

// INSERT INTO Orders (OrderNum, CustNum, Description, DateAdded)
//		VALUES(2000, 1, 'A First Order', '12-June-2000');
// INSERT INTO OrderDetails(OrderNum, Product, Quantity)
//		VALUES(2000, 'Chocolate Bars', 10);
// INSERT INTO OrderDetails(OrderNum, Product, Quantity)
//		VALUES(2000, 'Ice Creams', 20);

void Listing16_12()
{
	AdoNS::_ConnectionPtr pConnection;
	if(!GetConnection(pConnection))
		return;
	_bstr_t bStrSQL(_T("INSERT INTO Orders (OrderNum, CustNum, Description, DateAdded) \
		VALUES(2000, 1, 'A First Order', '12-June-2000')")); 
	MessageBox(NULL, bStrSQL, NULL, 0);
	ExecuteSQL(pConnection, bStrSQL);

	bStrSQL  = _T("INSERT INTO OrderDetails(OrderNum, Product, Quantity) \
		VALUES(2000, 'Chocolate Bars', 10)"); 
	MessageBox(NULL, bStrSQL, NULL, 0);
	ExecuteSQL(pConnection, bStrSQL);

	bStrSQL = _T("INSERT INTO OrderDetails(OrderNum, Product, Quantity) \
		VALUES(2000, 'Ice Creams', 20)"); 
	MessageBox(NULL, bStrSQL, NULL, 0);
	ExecuteSQL(pConnection, bStrSQL);

	cout << _T("Record Added") << endl;
	pConnection->Close();
}

// *** Listing 16.13
//
// Display Order and OrderDetails

void DisplayOrders(AdoNS::FieldsPtr & pFields)
{
	AdoNS::FieldPtr pField;
	_variant_t varValue, varIndex, varStringValue;
	_bstr_t bstrIndex;

	for(short i = 0; i < pFields->Count; i++)
	{
		varIndex = i; 
		pField = pFields->GetItem(varIndex);
		cout << (LPTSTR)pField->Name << _T(":");
		varValue = pField->GetValue();
		varValue.ChangeType(VT_BSTR, NULL); 
		cout << varValue.bstrVal << _T(" ");
	}
	cout << endl;
}

// SELECT * FROM Orders JOIN OrderDetails 
//		ON (Orders.OrderNum = OrderDetails.OrderNum)

void Listing16_13()
{
	HRESULT hr;
	AdoNS::_RecordsetPtr pRecordset;

	_bstr_t bstrConnection(lpConnection);
	_variant_t varConnection(bstrConnection); 
	_bstr_t bstrQuery(_T("SELECT * FROM Orders JOIN OrderDetails \
		ON (Orders.OrderNum = OrderDetails.OrderNum)"));
	_variant_t varQuery(bstrQuery); 

	hr = pRecordset.CreateInstance(_T("ADOCE.Recordset.3.1"));
	if(FAILED(hr))
	{
		cout << _T("Could not create recordset:") << hr << endl;
		return;
	}
	// Open the base table and retrieve rows
	//
	hr = pRecordset->Open(varQuery,
						varConnection, 
						AdoNS::adOpenStatic, 
						AdoNS::adLockReadOnly, 
						AdoNS::adCmdText);
	if(FAILED(hr))
	{
		cout << _T("Could not open recordset") << endl;
		return;
	}

	while(!pRecordset->GetA_EOF())
	{
		AdoNS::FieldsPtr pFields;
		pFields = pRecordset->GetFields();
		DisplayOrders(pFields);
		pRecordset->MoveNext();
	}
	pRecordset->Close();
}

// *** Listing 16.14
//
// Error Handling

// Ignore the following warning when using SEH:
// Warning C4509: nonstandard extension used: 'Listing16_14' uses SEH and 'bStrSQL' has destructor
#pragma warning( disable : 4509)  

void Listing16_14()
{
	AdoNS::_ConnectionPtr pConnection;
	HRESULT hr;

	if(!GetConnection(pConnection))
		return;
	_bstr_t bStrSQL(_T("BAD SQL Command ")); 

	__try
	{
		ExecuteSQL(pConnection, bStrSQL);
	}
	__except (hr = GetExceptionCode(),
				EXCEPTION_EXECUTE_HANDLER)
	{
		cout << _T("Trapped Failure: ") << hr << endl;
	}
	pConnection->Close();
	cout << _T("Finished") << endl;
}

// *** Listing 16.15
//
// Transactions

void Listing16_15()
{
	AdoNS::_ConnectionPtr pConnection;
	HRESULT hr;

	if(!GetConnection(pConnection))
		return;
	_bstr_t bStrSQL; 

	__try
	{
		pConnection->BeginTrans();
		bStrSQL = _T("DELETE FROM Orders");
		ExecuteSQL(pConnection, bStrSQL);
		bStrSQL = _T("DELETE FROM OrderDetails");
		ExecuteSQL(pConnection, bStrSQL);
		pConnection->CommitTrans();
	}
	__except (hr = GetExceptionCode(),
				EXCEPTION_EXECUTE_HANDLER)
	{
		cout << _T("Trapped Failure: ") << hr << endl;
		pConnection->RollbackTrans();
	}
	pConnection->Close();
	cout << _T("Finished") << endl;
}



