// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 14 MFC: COM and ActiveX Sample code Using MFC

#include "stdafx.h"
#include "examples.h"
#include "pimstore.h"

// *** Listing 14.12
//
//  See Chapter14MFC.cpp 

void Listing14_12(HWND hWnd)
{
	IPOutlookApp pOutlookApp;
	CString sVersion;

	if(!pOutlookApp.CreateDispatch(_T("PocketOutlook.Application"))) 
	{
		cout << _T("Could not create dispatch interface") << endl;
		return;
	}
	pOutlookApp.Logon((LONG)hWnd);
	sVersion = pOutlookApp.GetVersion();
	cout << _T("Version: ") << sVersion << endl;
	pOutlookApp.Logoff();
}

// *** Listing 14.13
//
// 

#define olTaskItem			3
#define olImportanceHigh	2

void AddTask(IPOutlookApp& pOutlookApp)
{
	ITask pTask;
	LPDISPATCH lpDispatch;

	lpDispatch = pOutlookApp.CreateItem(olTaskItem);
	pTask.AttachDispatch(lpDispatch, TRUE);
	pTask.SetSubject(_T("Task created from POOM"));
	pTask.SetBody(_T("The body text for task"));
	pTask.SetImportance(olImportanceHigh);
	pTask.Save();
}

void Listing14_13(HWND hWnd)
{
	IPOutlookApp pOutlookApp;
	CString sVersion;

	if(!pOutlookApp.CreateDispatch(_T("PocketOutlook.Application"))) 
	{
		cout << _T("Could not create dispatch interface") << endl;
		return;
	}
	pOutlookApp.Logon((LONG)hWnd);
	AddTask(pOutlookApp);
	pOutlookApp.Logoff();
}
