// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 13: System Information and Power Management Sample Code

#include "stdafx.h"
#include "examples.h"

// *** Listing 13.1
//
// Displays version information

void Listing13_1()
{
	OSVERSIONINFO osVersion;

	osVersion.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if(!GetVersionEx(&osVersion))
		cout << _T("Could not get version information") << endl;
	else
	{	
		cout << _T("Major Version:") << osVersion.dwMajorVersion << endl;
		cout << _T("Minor Version:") << osVersion.dwMinorVersion << endl;
		cout << _T("Build:") << osVersion.dwBuildNumber << endl;
		cout << _T("Platform ID:") << osVersion.dwPlatformId << endl;
		cout << _T("Other Info:") << osVersion.szCSDVersion << endl;
	}
}

// *** Listing 13.2
//
// SystemParametersInfo sample

void Listing13_2()
{
	TCHAR szOEMInformation[200];
	TCHAR szPlatformType[200];

	SystemParametersInfo(SPI_GETOEMINFO, 200, szOEMInformation, 0);
	cout << _T("OEM Information: ") << szOEMInformation << endl;
	SystemParametersInfo(SPI_GETPLATFORMTYPE, 200, szPlatformType, 0);
	cout << _T("Platform Type: ") << szPlatformType << endl;
}

// *** Listing 13.3
//
// Displays power information

void Listing13_3()
{
	SYSTEM_POWER_STATUS_EX2 sps;

	if(GetSystemPowerStatusEx2(&sps, sizeof(sps),TRUE) == 0)
		cout << _T("Could not get power status") << endl;
	else
	{
		cout << _T("AC Line: ");
		switch(sps.ACLineStatus)
		{
			case AC_LINE_OFFLINE:
				cout << _T("Offline") << endl;
				break;
			case AC_LINE_ONLINE:
				cout << _T("Online") << endl;
				break;
			case AC_LINE_BACKUP_POWER:
				cout << _T("Backup power") << endl;
				break;
			case AC_LINE_UNKNOWN:
				cout << _T("Unknown") << endl;
				break;
		}
		cout << _T("Battery: ");
		switch(sps.BatteryFlag)
		{
			case BATTERY_FLAG_HIGH:
				cout << _T("High") << endl;
				break;
			case BATTERY_FLAG_LOW:
				cout << _T("Low") << endl;
				break;
			case BATTERY_FLAG_CRITICAL:
				cout << _T("Critical") << endl;
				break;
			case BATTERY_FLAG_CHARGING:
				cout << _T("Charging") << endl;
				break;
			case BATTERY_FLAG_NO_BATTERY:
				cout << _T("No battery") << endl;
				break;
			case BATTERY_FLAG_UNKNOWN: 
				cout << _T("Unknown") << endl;
				break;
		}
		cout << _T("BatteryLifePercent: ") << sps.BatteryLifePercent << endl;
		cout << _T("BatteryLifeTime: ") << sps.BatteryLifeTime << endl;
		cout << _T("BatteryFullLifeTime : ") << sps.BatteryFullLifeTime << endl;
		cout << _T("BackupBatteryFlag: ");
		switch(sps.BackupBatteryFlag)
		{
			case BATTERY_FLAG_HIGH:
				cout << _T("High") << endl;
				break;
			case BATTERY_FLAG_LOW:
				cout << _T("Low") << endl;
				break;
			case BATTERY_FLAG_CRITICAL:
				cout << _T("Critical") << endl;
				break;
			case BATTERY_FLAG_CHARGING:
				cout << _T("Charging") << endl;
				break;
			case BATTERY_FLAG_NO_BATTERY:
				cout << _T("No battery") << endl;
				break;
			case BATTERY_FLAG_UNKNOWN: 
				cout << _T("Unknown") << endl;
				break;
		}
		cout << _T("BackupBatteryLifePercent : ") << sps.BackupBatteryLifePercent << endl;
		cout << _T("BackupBatteryLifeTime : ") << sps.BackupBatteryLifeTime  << endl;
		cout << _T("BackupBatteryFullLifeTime : ") << sps.BackupBatteryFullLifeTime  << endl;
		cout << _T("BatteryVoltage : ") << sps.BatteryVoltage  << endl;
		cout << _T("BatteryCurrent : ") << sps.BatteryCurrent  << endl;
		cout << _T("BatteryAverageCurrent : ") << sps.BatteryAverageCurrent  << endl;
		cout << _T("BatteryAverageInterval : ") << sps.BatteryAverageInterval  << endl;
		cout << _T("BatterymAHourConsumed : ") << sps.BatterymAHourConsumed  << endl;
		cout << _T("BatteryTemperature : ") << sps.BatteryTemperature  << endl;
		cout << _T("BackupBatteryVoltage : ") << sps.BackupBatteryVoltage  << endl;
		cout << _T("BatteryChemistry: ");
		switch(sps.BatteryChemistry)
		{
			case BATTERY_CHEMISTRY_ALKALINE: 
				cout << _T("Alkaline") << endl;
				break;
			case BATTERY_CHEMISTRY_NICD: 
				cout << _T("NICD") << endl;
				break;
			case BATTERY_CHEMISTRY_NIMH: 
				cout << _T("NIMH") << endl;
				break;
			case BATTERY_CHEMISTRY_LION: 
				cout << _T("LION") << endl;
				break;
			case BATTERY_CHEMISTRY_LIPOLY: 
				cout << _T("LIPOLY") << endl;
				break;
			case BATTERY_CHEMISTRY_UNKNOWN:
				cout << _T("Unknown") << endl;
				break;
		}
	}
}

// *** Listing 13.4
//
// Power-off device

void Listing13_4()
{
	keybd_event(VK_OFF, 0, KEYEVENTF_SILENT, 0); // down key
	keybd_event(VK_OFF, 0, KEYEVENTF_KEYUP | KEYEVENTF_SILENT, 0); // up key
}

