#ifndef	NSIG
#define NSIG	32

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt */
#define	SIGQUIT	3	/* quit */
#define	SIGILL	4	/* illegal instruction (not reset when caught) */

#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define		K_INT_OVF_T 0x1		/* integer overflow */
#define		K_INT_DIV_T 0x2		/* integer divide by zero */
#define		K_FLT_OVF_T 0x3		/* floating overflow */
#define		K_FLT_DIV_T 0x4		/* floating/decimal divide by zero */
#define		K_FLT_UND_T 0x5		/* floating underflow */
#define		K_DEC_OVF_T 0x6		/* decimal overflow */
#define		K_SUB_RNG_T 0x7		/* subscript out of range */
#define		K_FLT_OVF_F 0x8		/* floating overflow fault */
#define		K_FLT_DIV_F 0x9		/* divide by zero floating fault */
#define		K_FLT_UND_F 0xa		/* floating underflow fault */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */

/* these signals are not yet supported on nunix */
/*#define	SIGSTOP	17	/* sendable stop signal not from tty */
/*#define	SIGTSTP	18	/* stop signal from tty */
/*#define	SIGCONT	19	/* continue a stopped process */
/*#define	SIGCHLD	20	/* to parent on child stop or exit */
/*#define	SIGTTIN	21	/* to readers pgrp upon background tty read */
/*#define	SIGTTOU	22	/* like TTIN for output if (tp->t_local&LTOSTOP) */
/*#define	SIGTINT	23	/* to pgrp on every input character if LINTRUP */
/*#define	SIGXCPU	24	/* exceeded CPU time limit */
/*#define	SIGXFSZ	25	/* exceeded file size limit */

#define SIGSTAT 26	/* status update requested */
#define SIGMOUS 27	/* mouse interrupt */

#ifndef KERNEL
int	(*signal())();
#endif

#define	BADSIG		(int (*)())-1
#define	SIG_DFL		(int (*)())0
#define	SIG_IGN		(int (*)())1
#ifdef KERNEL
#define	SIG_CATCH	(int (*)())2
#endif
#define	SIG_HOLD	(int (*)())3

#define	SIGISDEFER(x)	(((int)(x) & 1) != 0)
#define	SIGUNDEFER(x)	(int (*)())((int)(x) &~ 1)
#define	DEFERSIG(x)	(int (*)())((int)(x) | 1)

#define	SIGNUMMASK	0377		/* to extract pure signal number */
#define	SIGDOPAUSE	0400		/* do pause after setting action */
#define	SIGDORTI	01000		/* do ret+rti after setting action */
#endif

/* old fashioned unix stuff */
#ifdef KERNEL
#define SIGINS	SIGILL
#define SIGTRC	SIGTRAP
#define SIGFPT	SIGFPE
#define SIGKIL	SIGKILL
#define SIGSEG	SIGSEGV
#define SIGCLK	SIGALRM
#define SIGTRM	SIGTERM
#endif
