#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include <sys/socket.h>
#include <netdb.h>
#include "/sys/netinet/in.h"
#include "/sys/netinet/in_systm.h"
#include "/sys/netinet/ip.h"
#include "/sys/netinet/ip_icmp.h"

#define	MAXPKTSIZ	1088
#define	TIMEOUT		5

struct pingpkt {
	struct icmp 	p_hdr;
	char		p_data[MAXPKTSIZ];
} outpkt;
u_char	inbuf[MAXPKTSIZ];
struct sockaddr_in sa;			/* foreign sockaddr */
char *fname;
int datasize = 0;

extern errno;

main(argc, argv)
int argc;
char *argv[];
{
	register int s;
	register struct sockaddr_in *sap;
	register struct icmp *picmp;
	register struct	protoent *pr;
	register char *p, *q;
	int farg;
	int i;

	unsigned short cksum ();
	extern int alarm_int ();
	extern struct sockaddr_in *resolve_host();

	if (argc < 2) {
		printf ("usage: %s [-s size] [-d data] host [...]\n",
					argv[0]);
		exit (1);
		}

	signal (SIGALRM, alarm_int);

	if ((pr = getprotobyname("icmp")) == NULL) {
		perror("Can't resolve icmp protocol");
		exit(1);
		}

	farg = 1;

	while (*argv[farg] == '-') {
		switch (*++argv[farg++]) {

		  case 's':	datasize = atoi(argv[farg++]);
				break;

		  case 'd':	p = argv[farg++];
				q = ((char *) &outpkt.p_hdr.icmp_ip);
				while (*q++ = *p++)
					datasize++;
				break;

		  default:	printf ("usage: %s [-s size] [-d data] host [...]\n",
						argv[0]);
				exit (1);

		  }
		}

	if (datasize > MAXPKTSIZ) {
		printf("%s: maximum packet size %d\n", argv[0], MAXPKTSIZ);
		exit(1);
		}

	outpkt.p_hdr.icmp_type = ICMP_ECHO;
	outpkt.p_hdr.icmp_code = 0;
	outpkt.p_hdr.icmp_cksum = 0;
	outpkt.p_hdr.icmp_cksum = ~cksum (&outpkt,
			(ICMP_MINLEN + datasize + 1) >> 1);

	for (i = farg; i < argc; i++) {
		fname = argv[i];

		if ((sap = resolve_host(fname)) == NULL) {
			printf("Don't know host %s.\n", fname);
			continue;
		}

		sa = *sap;			/* copy the beast */

		if ((s = socket(sa.sin_family, SOCK_RAW, pr->p_proto)) < 0) {
			perror("Can't open socket");
			exit(1);
		}

		if (connect(s, &sa, sizeof(sa)) < 0) {
			perror("connect error");
			exit(1);
		}
	
		if (send(s, &outpkt, (ICMP_MINLEN + datasize), 0)
					!= (ICMP_MINLEN + datasize)) {
			perror("send error");
			exit(1);
		}

		alarm(TIMEOUT);

		for (;;) {
			if (recv(s, inbuf, MAXPKTSIZ, 0) <= 0) {
				if (errno == EINTR)
					break;
				perror("recv error");
				exit(1);
			}

			picmp = (struct icmp *)inbuf;
			if (picmp->icmp_type == ICMP_ECHOREPLY) {
				alarm(0);
				printf ("%s responding.\n", fname);
				break;
			}
		}
		close(s);
	}
	exit(0);
}


int alarm_int (signo)
int signo;
{
	printf("%s not responding\n", fname);
}


unsigned short cksum (ibuf, ilen)

/* compute the 16-bit one's complement checksum of the specified
 * buffer.  The buffer length is specified in 16-bit words.
 * Note that if the length is odd, the next byte is zero cause
 * it's static and buffers are not reused.
 */

short	*ibuf;
int	ilen;
{
	register short *buf = ibuf;
	register int len = ilen;
	register int sum;

	sum = 0;
	while (len-- > 0) {
		asm ("addw2 (r11)+,r9");
		asm ("adwc $0, r9");
	}
	return (sum);
}
