/*  Copyright 1984, 1985 by Proteon, Inc. */
/*  See permission and disclaimer notice in file "proteon-notice.h"  */
#include	"proteon-notice.h"

#include <stdio.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <mach_type.h>
#include "pronet.h"

/* initialize the proNET interface. Basically, enable interrupts at the
	interrupt controller and the interface, and enable receive.
	Should also figure out our host address based on the hardware
	address, but to do that we have to send a packet, which is a bit
	more complicated than I want to do right now.
*/

char _prme;		/* my proNET address */
task *prDemux;		/* proNET packet demultiplexing task */
NET *pr_net;		/* my net pointer */
unsigned pr_eoi;

unsigned pr_int_base = INT_BASE1;	/* default for non-AT */
unsigned pr_ocwr = IOCWR;

int pr_demux();		/* the routine which is the body of the demux task */

pr_init(net, options, dummy)
	NET *net;
	unsigned options;
	unsigned dummy; {
	char temp;
	char initb;
	int i;
	int iimr = IIMR;

#ifdef	DEBUG
	if(NDEBUG & INFOMSG)
		printf("Forking prDEMUX.\n");
#endif

	prDemux = tk_fork(tk_cur, pr_demux, net->n_stksiz, "prDEMUX");
	pr_net = net;
	pr_net->n_demux = prDemux;

	/* if it's int 2 and the machine is an AT, hack, hack.

	if((custom.c_intvec == 2) && (_mach_type() == _IBM_AT)) { 
		custom.c_intvec = 1;
		pr_int_base = INT_BASE2;
		pr_ocwr = IOCWR2;
		iimr = IIMR2;
		}
*/

	/* here we should patch into the interrupt vector and initialize
		the v2lni
	*/
	int_off();
	pr_eoi = IEOI + custom.c_intvec; /* calculate the eoi command code */
	pr_int_base += custom.c_intvec<<2;
	pr_patch();

	i = custom.c_intvec;	/* silly broken compiler */
	outb(iimr, inb(iimr) & ~(1 << i));
	int_on();

	/* reset the lni */
	outb(mkv2(V2ICSR), INRST|MODE1|MODE2);
	outb(mkv2(V2OCSR), OUTRST);
	outb(mkv2(V2ILCNT), 0);
	outb(mkv2(V2IHCNT), 0);
	outb(mkv2(V2ICSR), MODE2|MODE1|COPYEN|ININTEN);

	/* We should also figure out our local ring address and use this to
		calculate our ring address. This is not trivial: we have to
		put ourself in loopback mode and broadcast a packet to
		ourself and look at the source address.
	*/

	tk_yield();	/* Give the per net task a chance to run. */
	return;
	}
