/*  Copyright 1984, 1985 by Proteon, Inc. */
/*  See permission and disclaimer notice in file "proteon-notice.h"  */
#include	"proteon-notice.h"

#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include "pronet.h"

/* Shutdown the proNET ring interface */

pr_close() {
	int i;

	if(NDEBUG & INFOMSG)
		printf("pr_close() called\n");

	if(!custom.c_otheruser) {
		if(NDEBUG & INFOMSG)
			printf("turning off interrupt controller\n");

		outb(mkv2(V2OCSR), 0);
		outb(mkv2(V2ICSR), MODE1|MODE2);
		i = 1 << custom.c_intvec;
		outb(IIMR, inb(IIMR) | i);
		}
	else if(NDEBUG & INFOMSG)
		printf("leaving interrupt controller alone\n");

	if(NDEBUG & INFOMSG)
		printf("unpatching interrupt vector\n");

	pr_unpatch();
	}
