/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

/* 10/3/84 - removed Init1(); changed to handle the new net structure
						<John Romkey>
   8/9/85 - rewrote to work with new NET structure.
						<John Romkey>
*/

#include <ether.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>

#define NULL	0

/* This is the network configuration file for the new IP code. This file
	sets up the configuration for a single ethernet interface
	machine. Programs which want to use multiple net interfaces
	should use their own configuration file.
*/

int Nnet = 1;		/* The number of networks. */

/* random fnctns. */
int et_init(), et_send(), et_switch(), et_stat(), et_close(), ip_ether_send();

NET nets[1] = { "3COM Ethernet",	/* interface name */
		et_init,		/* initialization routine */
		et_send,		/* raw packet send routine */
/*		et_switch,		/* interrupt vector swap routine */
		NULL,
		et_close,		/* shutdown routine */
/*		ip_ether_send,		/* ip packet send routine */
		NULL,
		et_stat,		/* statistics routine */
		NULL,			/* demultiplexing task */
		NULL,			/* packet queue */
					/* first parameter...*/
#ifdef	WATCH
		ALLPACK,		/* ...promiscuous mode for netwatch */
#endif
#ifndef	WATCH
		0,			/* ...normal mode for others */
#endif
		0,			/* second parameter unused */
		5400,			/* demux task stack size */
		14,			/* local net header size */
		0,			/* local net trailer size */
		0L,			/* ip address */
		0L,			/* default gateway */
		&custom,		/* our custom structure! */
		NULL			/* per interface info */
	};
