#include <stdio.h>
#include <q.h>
#include <attrib.h>
#include <colors.h>
#include <ctype.h>
#include <match.h>
#include "watch.h"

/* display header */
static char *hex_header =
" source     destination     type  len  0    1    2    3    4    5    6    7";
/*		 ^	       ^	*/

static char *sym_header =
" source     destination     type  len";
/*		 ^	       ^	*/

char *header;

/* ethernet handling stuff for netwatch */

extern struct nameber et_prots[];
extern struct layer et_layer;

struct ethdr {
	char et_src[6];
	char et_dst[6];
	unsigned et_type;
	};

unsigned long nbroadcasts = 0;
extern char local_net_disp;
extern char write_attrib;
extern int color_display;

char *unparse_ether();

norm_heading() {
	header = hex_header;
	}

sym_heading() {
	header = sym_header;
	}

et_unprs(data, y, x, len)
	register char *data;
	int y,x;
	unsigned len; {
	char buffer[200];
	register struct ethdr *eth = (struct ethdr *)data;
	char *addr;

	/* quick check if broadcast
	*/
	if((*(long *)data == 0xFFFFFFFF) &&
	   (*(unsigned *)(data+4) == 0xFFFF))
		nbroadcasts++;

	switch(prot_mode) {
	case MD_SYMBOLIC: {
		struct nameber *n;

		n = lookup(et_prots, (unsigned long)bswap(eth->et_type));
		if(n) {
			if(unknown_match)
				return FALSE;

			if(color_display)
				write_attrib = n->n_color;

			if(local_net_disp) {
				sprintf(buffer, "(%s ", unparse_ether(data+6));
				wr_string(buffer, y, 0, NORMAL);
				x = strlen(buffer);
				sprintf(buffer, "-> %s) ", unparse_ether(data));
				wr_string(buffer, y, x, NORMAL);
				x += strlen(buffer);
				}

			sprintf(buffer, "%s: ", n->n_name);
			wr_string(buffer, y, x, NORMAL);
			x += strlen(buffer);

			if(n->n_layer && n->n_layer->l_parse) {
				(*n->n_layer->l_parse)(data+14, y, x);
				break;
				}
			}
		else et_layer.l_unknown++;

		}

	case MD_NORMAL:

	if(color_display)
		write_attrib = BLACK<<4|WHITE;

	/* source address */
	addr = unparse_ether(data+6);
	wr_string(addr, y, x, NORMAL);

	/* destination address */
	addr = unparse_ether(data);
	wr_string(addr, y, x+13, NORMAL);

	data += 12;

	sprintf(buffer, "  %04x %4u ", bswap(eth->et_type), len);
	wr_string(buffer, y, x+26, NORMAL);
	data += 2;

	sprintf(buffer, "  %02x  %02x  %02x  %02x  %02x  %02x  %02x  %02x", 
		mkbyte(data[0]), mkbyte(data[1]), mkbyte(data[2]),
		mkbyte(data[3]), mkbyte(data[4]), mkbyte(data[5]),
				 mkbyte(data[6]), mkbyte(data[7]));
	wr_string(buffer, y, x+38, NORMAL);
	break;
	}

	return TRUE;
	}

/* ethernet filters - source, destination and type */

/* allow type to be specified as "ip udp nms" or "804" or "chaos"
*/

et_type(buf, offset)
	register char *buf;	/* the type specification */
	int offset;	{	/* offset into packet for ether header */
	struct nameber *n;
	char *s;
	int i;
	int retcode = F_OK;

	/* uggh this is ugly - will have to do this in every filter...
		so much for distributed parsing...
	*/

	/* look for a space */
	s = index(buf, ' ');

	if(s)
		*s = '\0';

	n = nlookup(et_prots, buf);
	if(!n) {
		/* okay, if it didn't match then if it is a question mark,
			print out all the types we know
		*/
		if(strcmp(buf, question) == 0) {
			scroll_start();
			printf("16 bit hexadecimal number\n\tor\n");
			print_namebers(et_prots);
			scroll_end();
			return F_PAUSE;
			}

		if(!isdigit(*buf)) {
			clr25();
			pr25(0, "bad packet type");
			return F_ERROR;
			}
		sscanf(buf, "%x", &i);
		}
	else i = n->n_number;

	/* if we did have a table lookup, chain to the next level unless
		there's nothing else to do

	   call before adding the bytes to the patterns so that if the
	   user types "ip tcp ?" we won't end up matching all ip/tcp
	   packets.
	*/
	if(n && n->n_layer && n->n_layer->l_type && s && *(s+1))
		retcode = (*n->n_layer->l_type)(s+1, offset+sizeof(struct ethdr));

	if(retcode != F_OK)
		return retcode;

	/* add the type field to both patterns */
	i = bswap(i);
	pt_addbytes(&pat1, &i, offset+12, 2);
	pt_addbytes(&pat2, &i, offset+12, 2);

	*s = ' ';

	return F_OK;
	}

et_addr(buf, offset, how)
	register char *buf;	/* the type specification */
	int offset;		/* offset into packet for ether header */
	char how; {
	struct nameber *n;
	char *s;
	int i;
	int retcode = F_OK;
	unsigned type;
	unsigned addr[3];		/* the address */
	char c;

	/* uggh this is ugly - will have to do this in every filter...
		so much for distributed parsing...
	*/

	/* look for a space */
	s = index(buf, ' ');

	if(s)
		*s = '\0';

	n = nlookup(et_prots, buf);
	if(!n) {
		/* okay, if it didn't match then if it is a question mark,
			print out all the types we know
		*/
		if(strcmp(buf, question) == 0) {
			scroll_start();
			printf("48 bit hexadecimal number\n\tor\n");
			print_addr_namebers(et_prots);
			scroll_end();
			return F_PAUSE;
			}

		/* if we make it here, then we should parse the ethernet
			address and add it to the appropriate patterns.
		 */
		if(strcmp(buf, "*") == 0) {
			for(i=0; i<3; i++)
				addr[i] = 0xffff;
			}
		else {
			/* THIS IS REALLY GROSS. */
			for(i=0; i<3; i++) {
				c = buf[i*4 + 4];
				buf[i*4 + 4] = '\0';
				sscanf(&buf[i*4], "%x", &addr[i]);
				addr[i] = bswap(addr[i]);
				buf[i*4+4] = c;
				}
			}

		/* insert in patterns */
		switch(how) {
		case 'S':
			pt_addbytes(&pat1, addr, offset+6, 6);
			pt_addbytes(&pat2, addr, offset+6, 6);
			break;
		case 'D':
			pt_addbytes(&pat1, addr, offset+0, 6);
			pt_addbytes(&pat2, addr, offset+0, 6);
			break;
		case 'W':
			pt_addbytes(&pat1, addr, offset+0, 6);
			pt_addbytes(&pat2, addr, offset+6, 6);
			break;
			}

		return F_OK;
		}

	/* if we did have a table lookup, chain to the next level unless
		there's nothing else to do

	   call before adding the bytes to the patterns so that if the
	   user types "ip tcp ?" we won't end up matching all ip/tcp
	   packets.
	*/
	if(!(n && s && *(s+1)))
		return F_OK;

	retcode = (*n->n_layer->l_addr)(s+1, offset+sizeof(struct ethdr), how);

	if(retcode != F_OK)
		return retcode;

	/* since we're matching on a protocol address, we can
		only accept packets of that protocol
	 */
	type = bswap(n->n_number);
	pt_addbytes(&pat1, &type, offset+12, 2);
	pt_addbytes(&pat2, &type, offset+12, 2);
	return F_OK;
	}


/* ethernet address hacking - define a table of the first three bytes
	of ethernet addresses versus manufacturer
	five characters max for manufacturer's name because of display
	formatting
*/
struct nameber ether_makers[] = {
	{ 0x020701,	"Intrl",	0, NULL },
	{ 0x02608c,	"3COM",		0, NULL },
	{ 0x080005,	"Sym",		0, NULL },
	{ 0x080020,	"Sun",		0, NULL },
	{ 0xaa0004,	"DEC",		0, NULL }
	};

char manu_switch = FALSE;

long lswap();

char *unparse_ether(addr)
	char *addr; {
	static char buffer[80];
	struct nameber *n;
	unsigned long a;

	if((*(long *)addr == 0xFFFFFFFF) &&
	   (*(unsigned *)(addr+4) == 0xFFFF))
		return "      *     ";

	if(manu_switch) {
		a = *(unsigned long *)addr;
		a = (lswap(a) >> 8) & 0xFFFFFF;
		n = lookup(ether_makers, a);

		if(n) {
			sprintf(buffer, "%s %02x%02x%02x", n->n_name,
					mkbyte(addr[3]), mkbyte(addr[4]),
					mkbyte(addr[5]));
			return buffer;
			}
		}

	sprintf(buffer, "%02x%02x%02x%02x%02x%02x ", mkbyte(addr[0]),
			mkbyte(addr[1]), mkbyte(addr[2]), mkbyte(addr[3]),
					mkbyte(addr[4]), mkbyte(addr[5]));
	return buffer;
	}

/* stub the internet demultiplexer
*/
indemux() {
}

in_stats() {
}
