@part[tftps, root "manual"]

@string[sectiontitle = "@b<tftp> server"]
@newpage

@section[TFTP Server]
PC/@b[tftp] server, version 7.3


An implementation of a file transfer server for the IBM PC.


@Begin[format]
Usage:

     @b[tftp] serve
or
     @b[tftp] serve spool
@End[format]

The PC/@b[tftp] server package allows users at other network hosts 
to initiate file transfers to and from this PC.  The option
@i"spool" disables write blocking, to allow the tftp server to
be used as a print spooler.


Notes:
@Begin[itemize]
Server @b[tftp] can also be invoked from within the @b[telnet]
command, while logged in to another host.  See the writeup of 
PC/@b[telnet] for usage instructions.

While server @b[tftp] is running, no other use can be made of the
PC.  To turn server @b[tftp] off, type "q".  If a file transfer is
already in progress, server @b[tftp] will shut down immediately,
leaving the host at the other end of the transfer wondering where
it went.

There is no access control whatever.  The @b[tftp] server allows
a remote host to initiate a @i"get" or @i"put" operation for any file
on any accessible disk.  (The version of the @b[tftp] server that is
invoked from PC/@b[telnet] asks the user for confirmation of each
file transfer request that it receives.)

The PC-DOS operating system is not designed for unattended
use, so leaving a PC alone with the tftp server running does not
work very well.  For example, if the distant host tries to
initiate a put to a write-protected diskette or unreadied disk
drive, PC-DOS will stop in its tracks and ask the operator of
this PC what to do.  Until someone answers this query, the tftp
server appears to be dead.

In initiating file transfers from other hosts, the user at
the other host must know the IP address of the PC that is running
server tftp.  This IP address may not be associated with any name
table name.  [In Berkeley UNIX 4.2, one can learn the IP address 
of the host originating a telnet connection by using the command
"who am I".  This feature simplifies transferring files back to
the PC from which one originated a telnet connection.]

PC-DOS will prefix any file name supplied by the foreign host 
with the default drive and the default working directory for that 
drive.  To override these defaults, the foreign tftp initiator 
can supply a full drive descriptor and path name.  However, 
because of the special characters (colons and back-slashes)
appearing in fully qualified PC-DOS file names, one may have
to use some quoting convention on the foreign host to type the
file name at command level.  [For example, on another PC, path
names should be enclosed in double quotes.  On UNIX, back-slash
characters should be doubled or replaced with forward-slash
characters, which PC/@b[tftp] will accept instead.]

The tftp server permits only one file transfer at one time.
If any host requests a transfer while one is already in
operation, the tftp server will refuse the second request.

The tftp server can be used as a print spooler, simply
by telling the tftp user to send files to the appropriate
device file name (such as PRN or LPT1).  When used this way,
the usual write blocking done by the tftp server sometimes
interferes, since the tftp server accumulates up to 10K bytes
of transferred data before initiating the first write to the
device.  On trying to send the next block of data, the tftp
client may then time out and give up because the server PC
will concentrate all its attention on the printer for a long
time.  The server should be started with the option
@i"spool" to disable write blocking.
@End[itemize]

See also the writeups of PC/@b[tftp] and PC/@b[telnet].


16 September 1985.  This document is in file tftps.mss
