@part[ping, root "manual"]

@string[sectiontitle = "@b<ping>"]
@newpage

@section[Ping]
PC/@b[ping], version 5.0

A program to send an echo request to another host and watch
for a response, using the ICMP/IP protocol.  It is used primarily
to isolate trouble in an internetwork environment.

@Begin[format]
Usage:

     @b[ping] hostname
@End[format]

Where @i"hostname" is either a character-string name of the target
or an internet address in standard form.  (See the section on
hostnames in the network overview for more details.)  The hostname
@i"me" will send an echo request addressed to the computer on which
the command is typed.

@B[Ping] reports success with a message such as "Host x,y,z,w responding"
where x,y,z,w is the internet address of the target.  It may also
report one of several failures:
@Begin[itemize]
Host not responding

Host responded but the returned echo packet was defective

The initial echo request packet could not be sent
@End[itemize]

When exiting, @b[ping] also prints an array of statistics about its
operation.  These statistics are in two categories:  details of
local network usage and details of packets processed.  These
statistics often provide clues about network problems to a network
specialist.


@subsection[Optional features]

     @b[ping] -t hostname

will go into a loop continually sending echo requests to host
@i"hostname", each time waiting for a response before sending the
next request.  To exit this loop, type the single letter "q".
When in looping mode @b[ping] reports all echo failures, and also
maintains a summary line of trials and successes.

     @b[ping] -s

starts an echo server, a program that will respond to echos sent
to this PC from elsewhere in the network.  (Note that all PC/IP
programs, including @b[ping], always act as echo servers whenever they
are in control of the PC.)


@subsection[Using ping to isolate network trouble]

When a host fails to respond, it may mean either that that host
is down or that some network or gateway in the path from the user
to the host is down.  (It could also mean that the host does not
implement the IP/ICMP echo request protocol.)  Further @b[ping]
experiments can usually determine which (and thus whom to call
for repair.)  A successful @b[ping] directed to another host on the
same network as the original host usually means that the original
host is down or not listening to the network.  Failure to get
echos from any host on that network means that the trouble is
along the path somewhere.  A @b[ping] directed to the gateway into
the network in question is the next step.  One can continue to
work back from the target toward the originator until the point
where communication breaks down is found.

The echo request sent by the @b[ping] command is dispatched using
a low-level protocol that does not try to guarantee delivery.  
As a result, there is a possibility that any one echo request
may be accidentally lost for some reason such as temporary
overload in some gateway.  Thus one cannot be confident that a
particular network or gateway has failed unless a series of @b[ping]
experiments consistently succeed in getting to the point in
question and consistently fail to get beyond that point.


@subsection[Using ping to evaluate a serial line]

Since @b[ping] contains a built-in echo server it can be used to test
or evaluate a serial line in two ways.  If a gateway is attached
at the other end of the serial line, the command "@b[ping] me"
exercises the serial line in both directions as well as the
gateway. Alternatively, if one loops back the other end of the
serial line so that all data sent down the line comes immediately
back to the PC, the command "@b[ping] me" will still work, using  an
internet address chosen by @b[ping].  In both cases, the command form
"@b[ping] -t me" is appropriate to start a continual test of the
line. Any packets damaged in transit will lead to error reports;
the summary of tries and successes provides a picture of the
total effect of line noise.


26 October 1984.  This document is in ping.mss
