@part[netwatch, root "manual"]

@string[sectiontitle = "@b<netwatch>"]
@newpage

@section[Netwatch]
PC/@b[netwatch], version 7.0


A program to monitor the attached local network.  It is useful
primarily for debugging network operations on a broadcast network.

@Begin[format]
Usage:

     @b[netwatch]
@End[format]

No arguments are required.  PC/@b[netwatch] listens to the attached
local broadcast network and displays one line of information for
every packet that goes by.  This information consists of the "to"
and "from" local network addresses, the packet length, the value
of the protocol type field, and 8 selected contiguous bytes of
the packet contents.  While @b[netwatch] is running one may type
commands to it. The commands either display collected information,
change @b[netwatch]'s operating mode, or tell it to filter for
specific types of packets. The commands are:
@Begin[description]
a@\Match all packets. Turns off all packet filtering.

c@\Display packet type counts. Prints a list of all packet types that
are built in to @b[netwatch] and how many of each type it has accepted
and displayed. Some counts are misleading because some protocols have
two type indicators in their headers (TCP and UDP packets have two
socket numbers).

d@\Match on destination. Prompts the user to input a destination
address and only accepts packets going to that address. See the
section below on filtering for more information.

h@\Display packet length histogram. Displays a list of packet lengths
in 64 byte increments and a count of how many packets of each length
have been accepted and displayed by @b[netwatch].

l@\Clear screen.

m@\Toggle using manufacturer info in hardware addresses. This command
is only useful on Ethernet @b[netwatch]s. The first three bytes of an
Ethernet address can be used to determine the manufacturer of the
Ethernet card the address is associated with. This command toggles
whether or not @b[netwatch] prints the first three bytes as
hexadecimal numbers or symbolically as the name of the manufacturer.

n@\Toggle normal and symbolic modes. Switches between the mode where
@b[netwatch] simply dumps packets in hex and the mode where
@b[netwatch] unparses packet headers and displays a symbolic
representation of the contents of the packet.

p@\Pause. Waits for the user to type something before proceeding.

q@\Quit. Return to PC-DOS.

r@\Reset packet count. Resets the count of accepted packets to 0.

s@\Match on source. Prompts the user to input a source
address and only accepts packets coming from that address. See the
section below on filtering for more information.

t@\Match on packet type. Prompts the user to input a packet type
specification (see below on filtering) and only accepts packets of
that type.

u@\Match only on unknown packets. @b[Netwatch] will only accept and
display packets of types it does not know. This feature interacts
incorrectly with some of the internal counters in netwatch; some packet
counters will still increment on packets that do not get displayed.

w@\Match all packets coming to or from an address. Prompts the user to
input an address and accepts and displays only packets coming from or
going to that address. See below on filtering.

A@\Shows more application layer information when displaying packets.

H@\Display histogram of packet lengths. This command shows a bar graph
of packet lengths and counts.

I@\Shows more internetwork layer information when displaying packets.

L@\Toggle displaying local net addresses. When displaying local net
address, @b[netwatch] will display hardware source and destination
addresses even when in symbolic mode.

N@\Shows more network layer information when displaying packets.

S@\Print statistics.

T@\Shows more transport layer information when displaying packets.

?@\Print command summary.
@End[description]

@subsection[Filtering]

@b[Netwatch] allows the user to specify filters for packets. Only
packets matching those filters will be accepted and displayed.
@b[Netwatch]'s internal counters (length and counts of different
packet types) only count accepted packets.

The simplest filter is on packet type. Packet types can be symbolic or
numeric. For instance, on an Ethernet, one can match on packet type
"ip" or packet type "800". Higher level protocols can be matched on as
well; you can match on "ip tcp" or "ip tcp telnet". A '?' anywhere in
the type specification will cause @b[netwatch] to respond with a list
of acceptable types.

@b[Netwatch] can also filter on addresses. There are three types of address
matching: source, destination and watching (source @i[or]
destination). Both hardware and protocol addresses can be specified.
On a proNET ring, you might type "99" as a hardware address. On any
hardware, you could specify "ip 18.26.0.65" as an Internet protocol
address or "chaos 15101" as a Chaosnet protocol address. You can
specify the hardware broadcast address as "*" or the numeric address.

@subsection[Combining Filters]

Filters can be combined: you can look for all "ip tcp telnet" packets
coming from host "ip 18.26.0.65", or you can combine hardware
addresses and protocol addresses. There are a few catches to be wary
of.

None of the filters clear the old filters when you start. Therefore
you should normally use the 'a' command to accept all packets before
you change the type or address @b[netwatch] is matching on. 
Some combinations make no sense, for instance, watching for packets
coming to or from "ip 18.26.0.65" and then watching for packets coming
to or from "chaos 15101". In this case, @b[netwatch] will probably
never see @i[any] packets, because it is looking for packets with the
correct bytes in right positions for @i[both] of those addresses.

Also, watching on both hardware and protocol addresses might miss some
combinations of both.

@subsection[Performance]

The limitations of the monitor in high-traffic situations should
be understood.  The monitor can handle a burst rate of about 200
packets per second.  Packets arriving faster than that are missed
(but counted in the statistics of the network driver).  In
addition, the display rate is about 25 packets per second and
there is a buffer that can hold 512 undisplayed packets.  If
packets arrive faster than the display rate for a long enough
time to fill up the buffer, the monitor discards overflow
packets.

Note:  When the proNET version of @b[netwatch] is used, a jumper must be
set in the hardware to permit the interface to accept all packets.

2 October 1985.  This document is in file netwatch.mss
