@part[hostnames, root "manual"]

@string[sectiontitle "Host names"]
@newpage
@section[Host Names and Internet Addresses]

A brief description of the syntax of host names and internet 
addresses, and the method by which host names are resolved.

When PC/IP network programs accept a hostname argument it may be 
in either of two standard forms:

@Begin[description]
Internet address@\An internet address is four octal 
        integers separated by commas, for example:@*
@center[22,11,0,127]
        or four decimal integers separated by periods, for example:
@center[18.9.0.87]
        Each integer represents one byte of a 32-bit standard 
        internet address, in the order "network," "subnet," etc.  
        When the user supplies an internet address the PC/IP 
        network program uses it as is, depending on nothing else 
        for name resolution.

Host name@\When a PC/IP network program encounters a string that does
not appear to be an internet address, it interprets the string as a
host name and it attempts to resolve the name by appeal to one or more
name servers via the network.  The program sends inquiries to as many
as three domain name servers and two old-style name servers whose
internet addresses are embedded in the @i[netdev.sys] file. (The user
may change the number of name servers and their internet addresses by
use of the PC/IP program @b"custom".)
@End[description]

If a text name is given, first up to three domain name servers are
polled in succession. If the name is a fully qualified domain name
then it is passed intact to the domain name servers; otherwise the
domain specified with PC/@b[custom] is appended to the end of the
name. If none of the domain name servers can resolve the name (or if
no domain server addresses are specified) the old-style name resolver
is used.

The old-style name resolve can produce three outcomes,
since name servers may reply with an internet address, reply with
a "host name unknown" response, or may not reply at all.  To
increase availability several name servers are polled, and the
following rules merge the resulting replies:
@Begin[enumerate]
If one or more name servers respond with an internet 
        address, the program uses the first such response received 
        and ignores all later responses.

If one or more name servers respond, but all the responses 
        are "host name unknown," the program displays that error 
        message and exits.

If no response arrives from any name server within five 
        seconds, the program gives up, displays the error message 
        "name servers not responding," and exits.
@End[enumerate]

Note that if different name servers give different responses to 
the same inquiry, the user may see erratic results depending on 
which name servers are up and which respond more quickly.  If one 
suspects that name servers are not responding or are not in 
agreement, the commands @i[netname] and @i[onetname] may help isolate
the trouble.

17 January 1986.  This document is in file nameres.mss
