@part[lpr, root "manual"]

@string[sectiontitle = "@b<lpr>"]
@newpage
@section[Lpr]

PC/@b[lpr], version 3.0

A program to send a text or graphics file to a local or remote
printer.  Emulates the Unix lpr command to a limited extent.

@Begin[format]
Usage

     @b[lpr] [ -Pprinter] [ -Sserver] [-pgvqw] filename
@End[format]

causes the file @i"filename" to be spooled to a printer.  The -P option
may be used to force output to a specific printer, and the -S
option may be used to specify a print server.

If the option "-P" is given, the word following the "-P" is taken
as the name of the printer to be used.   If the "-P" option is
missing, the name of the printer to be used is taken from the
@c[PRT] environment variable.  If this variable has not been set,
the name of the printer is taken to be @i"lp".  (Note that the
option may be written "-P printer" OR "-Pprinter", as in the
UNIX convention for the @b[lpr] command.)

The name of the printer, whether taken from the "-P" option, the
environment variable, or defaulted, is significant.  The following
names have special meanings:
@Begin[description]
local@\If the printer name is "local", the file is printed with the DOS
"PRINT" command.  There must be a printer attached to the PC issuing
the command, and the normal messages issued by "PRINT" will be
displayed and should be responded to.

prn,lpt1,lpt2,com1,com2@\If the printer name is any of these names,
          which have special meaning to DOS, PC/@b[lpr] assumes that the print
          server is another PC on the network that is running a PC/@b[tftp]
          print server and possibly a spooler.  PC/@b[lpr] will send the file
          to that PC by means of the tftp protocol, using the given printer
          name as the target device.  If the server PC has a printer
          attached under that device name, it will print the file there.

all other names@\If the printer name is any other value, PC/@b[lpr] assumes
          it to be the name of a UNIX printer controlled by a UNIX/lpd daemon,
          running the 4.2bsd printer protocol.  In these cases,
	  PC/@b[lpr] creates 
          a cover sheet with the user's name (taken from the @c[USER]
	  environment
          variable), the name of the file, and the office number (taken from
          PC/IP customization information).  It then sends the file to the
          UNIX/lpd daemon for printing.
@End[description]

If the option "-S" is given, the word following the "-S" is taken as
the internet name or address of the print server to be used.  If the
"-S" option is missing, the identity of the print server to be used
is taken from an environment variable named "SERVER" or if there is no
environment variable, from 
the customization parameter "default print server".
(Note that the option may be written @w{"-S server"} OR "-Sserver".)

If the option "-q" is given, PC/@b[lpr] displays no messages
unless it encounters an error.

If the option "-w" is given, and the file was sent to a UNIX print server, 
PC/@b[lpr] will wait until the server closes the network connection 
before exiting.  If the printer is directly attached to the server, 
this is a way to wait until the file has started printing.

The following single letter options are used to specify that a filter
is to be used on the file before printing it.  In all cases, a
temporary file will be created, modified by the filter, spooled to
the printer, and then erased:
@Begin[description]
-p@\@b[pr] is used to format the file.  If the print server
          is running Unix, it will process the file with the normal
          Unix pr command. If the print server is running DOS, PC/@b[lpr]
          will run the file through a DOS pr filter before printing.
          In either case, the file is printed in pages with a five-line
          margin at the top and bottom, and a header line consisting of
          the date, time, name of file, and page number, on the third
          line of each page.

-g@\prntmeta is used to format the file.  This is a DOS-only graphics
          filter which translates GKS meta files for printing on the
          IBM Graphics Printer.

-v@\this option is reserved for future use for files in
printer-specific formats. There is currently no support for this option.
@End[description]


@subsection[Customization]

The following parameters of PC/@b[lpr] can be customized with the
PC/@b[custom] command:
@Begin[enumerate]
Internet address of a remote print server.

Name of the user, for the cover sheet.
@End[enumerate]

The following parameters of PC/@b[lpr] can be customized by setting DOS
environment variables:
@Begin[enumerate]
printer name, set with "set prt=name"

user name, set with "set user=name"

server name, set with "set server=name"
@End[enumerate]

@subsection[Notes]

All PC/IP packages follow the DOS convention of returning an
ERRORLEVEL value when they exit.  For use in batch files,
PC/@b[lpr] returns ERRORLEVEL=0 if the printer service accepts the
file, and ERRORLEVEL=1 otherwise.



26 February 1986.  This document is in file lpr.mss
