@part[debugging, root "manual"]

@string[sectiontitle = "Debugging"]
@newpage

@section[Debugging options]

This section explains the operation and usefulness of the
debugging option switches that can be set using the customizer.

The PC/IP packages have built in as part of their design a large
number of error and progress report messages, but these messages
do not appear on the display screen unless specifically requested.
The debugging option switches control which messages the packages
display.  When troubles appear in the use of network programs, it
is often not immediately apparent whether the cause is a problem
in the local computer system, in some distant server, or in some
network in between.  The tracing that is controlled by the
debugging switches has as its primary value that it can allow
fairly rapid trouble isolation in such circumstances.

The arrangement of the debugging option switches in the PC/IP
packages has evolved as the requirements for tracing have become
better understood; this evolution is incomplete and there are
quite a number of cases where different packages and different
levels of network protocol do not yet follow consistent
conventions.  

The debugging switches can be set ON or OFF as customization
options.  The usual technique is to customize the debugging
options to the ON position in the @i"netcust:" device  so that they
apply only to the current session.  However, as is described below
some users may find it helpful or interesting to customize the
first few of the switches permanently ON (in the file
@i"netdev.sys") to allow monitoring of network status and problems.
Each debugging option switch is described here and in the
customizer by a symbolic name.

Here are the message categories controlled by each debugging
switch:
@Begin[description]
NETERR@\Reports all recoverable errors detected by the local
network (Ethernet, proNET, or serial line) driver.  Can be left
ON during normal operation to monitor appearance of network
troubles. 

PROTERR@\Reports all packets received that seem to be
inappropriate for the protocol being used, or that represent some
other trouble at the protocol level.  Primarily useful for
debugging other implementations or discovering incompatibilities
between implementations on different computer systems.  Can be
left ON during normal operation to serve as a warning that one
has contacted a host that isn't following protocol in the
expected way. 

TIMEOUT@\Reports all timeouts waiting for the other end of a
connection to respond.  Can be left ON during normal operation to
monitor frequency of timeout-triggered retries.

APTRACE@\Provides a trace of the activities of the application
level protocol.  For example, in PC/@b[tftp], APTRACE produces a
one-line message for each file block that is sent or received.
Can be left on during normal operation if progress reports are
important or useful, but tends to fill the screen with tracing
messages.
@End[description]

The following debugging options are primarily useful for finding
problems in the interactions between the PC network protocol
implementation and those of other machines.  They generally
produce so much output that they are best left off unless they
are really needed. 

@Begin[description]
TCTRACE@\Provides a trace of the activities of the transport level
protocol, such as UDP or TCP.  Produces a one-line message for
each packet that is sent or received at the transport level.

INTRACE@\Provides a trace of the activities of the internet
protocol level, IP or ICMP.  Produces a one-line message for each
packet that is sent or received by the internet level.

NETRACE@\Provides a trace of the activities of the local network
driver.  Produces a one-line message for each packet that is sent
or received on the local network.

DUMP@\Whenever an incoming packet seems to have something
wrong with it, this switch causes its contents to be displayed
in hexadecimal format.  In conjunction with NETRACE, INTRACE,
or TCTRACE, will produce a symbolic dump at the appropriate
level. (Note that the time required to display a complete
packet contents may exceed the timeout/retransmit time of some
hosts, so setting this switch ON can significantly alter
the sequence of packets received and sent.)

INFOMSG@\Triggers a long list of informational and progress
report messages.  Used primarily to find out how far a PC/IP
package got before it crashed.  

BUGHLT@\Displays a message whenever the network level code of
PC/IP detects a gross application error of some kind.  (Not
actually used very much.)
@End[description]

The PC/@b[telnet] command has a special tracing feature that is
useful for tracking interactions with a remote time-sharing host.
The PC/@b[telnet] escape F10/control-A toggles the APTRACE debugging
switch described above.  When APTRACE is ON, PC/@b[telnet] displays
on line 25 a cryptic progress report (updated once per second) on
the connection to the other host.  This report appears as
follows:

@Begin[verbatim]
Sent: N1(N2)N3  Rcvd:  N4(N5)N6  Window: N7
@End[verbatim]

with the following interpretation:
@Begin[description]
N1@\Number of bytes sent by the PC to the other host.

N2@\Number of sent bytes not yet acknowledged by the 
            other host.

N3@\Number of packets resent to the other host in hope 
            of eliciting an acknowledgement. 

N4@\Number of bytes received from the other host.

N5@\Number of received bytes not yet acknowledged to
            the other host.

N6@\Number of packets rereceived (that is, duplicates)
            from the other host.

N7@\Number of bytes that PC/IP has authorized the other
            host to send.  (TCP window size.)
@End[description]

Note that while ON, APTRACE also triggers a one-line-per-block
message from the tftp server if it used from within PC/@b[telnet].

PC/@b[telnet] can be asked to toggle any debugging switch at any
time, using F10 followed by the appropriate control- character.
Several other debugging and maintenance toggles and displays are
also available.  F10/control-H displays a list of possibilities.



16 September 1985.  This document is in file debugging.mss.
