@part[srl-prot, root "progman"]

@appendix[Serial line Framing Protocol]

@begin[i]
This description is from a very old file written when we were first
implementing the protocol. Details are still accurate, though.
@end[i]

	This is preliminary documentation on the serial line protocol used
between the IBM PC's and the PC Gateway. The protocol has two levels:
the low-level protocol (LLP) and the local net protocol. The low level protocol
wraps a packet and delivers it to the PC Gateway. The local net protocol tells
the PC Gateway what kind of packet it is. Currently there are two types of
packets: Internet and Address Request. When the PC Gateway receives an Internet
packet, its action is to forward the internet packet to a process which checks
the packet for validity and then sends it to the net. On receipt of an Address
Request packet, the PC Gateway sends an Address Request packet back to the PC
with four bytes of data (the PC's internet address) in the body of the packet.

	Neither the LLP nor the local net protocol provide for prioritized
transmissions, checksums or complex line control. They are merely a simple way
to get packets to and from machines.

The local net protocol consists of a four byte leader. For an internet
packet, this leader is: 2,1,0,0. For an Address Request, the leader is
2,3,0,0.  There is no data in the Address Request packet sent from the PC;
it is only the four byte local net header wrapped in the serial line
protocol.

	The receipt of any packet with a local net header that does not
identify the packet as either internet or address request is an error and the
receipt of such a packet should be logged and the packet discarded.

LLP consists of four bytes with special meanings when received over the
serial line. These are: ESC, REQ, ACK, and END.

A packet is enclosed in a REQ and an END. When a PC wishes to send a packet
it first sends a REQ to the PC Gateway. It then waits a suitable length of
time to receive an ACK from the PC Gateway. If no ACK byte is received, the
PC Gateway is assumed to be unable to handle the packet right now and a
timeout is said to have occurred. The PC may either retry, wait or return an
error.

After the PC receives the ACK signal, it may begin sending the packet.  The
first four bytes of the packet should be the local net header and an error
will occur if they are not valid. When the PC has completed sending the
packet, it should send an END byte to the Gateway. The PC gateway will the
consider the packet and act upon it.

The PC Gateway goes through a similar process when it sends a packet to a
PC; only the roles are reversed. It is an error for the PC Gateway to send a
PC its address if the PC has not requested its address from the Gateway.

	If a machine should receive a REQ embedded in a packet, this indicates
that the END signal was dropped somewhere. The receiving machine should drop
the packet it was receiving and begin to receive a new one. ACKs may be mixed
inside packets to allow immediate response to REQs. The receipt of an ACK by
a machine should be duly logged (and perhaps appropriately ignored if the
PC doesn't have an outstanding request).

	The final code, ESC, is used to allow the characters whose codes are
used by ESC, REQ, ACK and END to appear in packets. Receiving an ESC indicates
that the next byte should be looked at to produce the correct character. Here
is a table of the codes for the signals and the ESC sequences to produce the
data whose codes they use.

@begin[verbatim]
ESC	242	ESC 0
REQ	243	ESC 1
ACK	244	ESC 2
END	245	ESC 3
@end[verbatim]

A simple way to unstuff the bytes is to add the character following an ESC to
the ESC to get the correct code and then put it in the packet as data. It is
an error to have any character > 3 follow an ESC.

	If a machine receives any character other than a REQ or an ACK when it
is not in the process of receiving a packet, it should discard that character.


Low-level protocol specification:  IBM to Gateway, Gateway to IBM

The following ASCII codes are used as flags in the manner specified:

@begin[verbatim]
242	- Prefix code for sending data codes which are set aside for
	  protocol use.
243	- Request to send (REQ).
244	- Acknowledge (ACK).
245	- End of packet (END).
@end[verbatim]

A typical data transfer occurs as follows:
@begin[verbatim]
IBM wants to send packet to Gateway:	It sends REQ and waits for ACK.
Gateway is ready to receive packet:	It sends ACK.
IBM sends packet to Gateway followed by END.
@end[verbatim]

The packet itself is encoded so that REQ, ACK, and END never appear in the
text.  This is done by performing the following substitutions:

@begin[verbatim]
242 --> 242 0
243 --> 242 1
244 --> 242 2
245 --> 242 3
@end[verbatim]

Note that transfers can occur in both directions simultaneously.  However,
the ACK signal may be embedded within a data packet and must be
explicitly removed:

@begin[verbatim]
IBM wants to send packet to Gateway:	It sends REQ and waits for ACK.
Gateway is ready to receive packet:	It sends ACK.
IBM starts sending packet.
Gateway wants to send packet to IBM:	It sends REQ and waits for ACK.
IBM is ready to receive packet:		It sends ACK.
IBM continues sending its packet, while Gateway sends a packet to IBM.
@end[verbatim]

Timeouts may occur if the wait between a REQ and an ACK is too long or no
packet characters are transmitted for too long a time.  In both cases no
recovery action is undertaken:  the other system is assumed to have crashed.

Receipt of protocol codes within a data packet has the following consequences:

@begin[verbatim]
REQ	- End portion of data packet being sent has been lost.
ACK	- Should be removed from input packet and its presence logged for
	  use by the process which is sending characters.
END	- Packet has been completely sent.
@end[verbatim]
