@part[overview, root "progman"]

@chapter(Overview)

@i[The current version of the programmer's manual is not greatly
changed from the previous version. In some cases, sections are now
slightly out of date, but there are few untruths in the document.
There is, however, much left to be documented that will never be in
this document.]

@section[Introduction]

The IBM PC network code implements the DoD standard Internet protocol family
@Cite[Internet]. This system includes drivers for the 3COM 10Mbps ethernet
interface @cite[3com1]@cite[3com2], the Proteon proNET ring interface
@cite[pronet], and for serial lines running a special link level protocol
which requires a special gateway. A high level of modularity is forced on
the code by the requirement that it be able to use different net interface
drivers easily. Packages that are available are user telnet, user and server
tftp, user finger (the "whois" program in this release), user cookie, user
smtp, user and server ping, and user setclock, user hostname resolution,
user nicname, and netwatch.

The code is structured in a somewhat unusual manner. It includes a small,
nonpreemptive multitasking system. Its history is long, starting with Dr.
David Clark's TCP for the Xerox Alto, running to Larry's Allen's translation
of this from BCPL to C for Unix, to Lou Konopelski's port to the PC, and my
cleanups and additions. The Internet began as a port from Larry Allen's Unix
Internet, but later was almost totally rewritten to work with tasking by me.

The system was originally developed on a PDP 11/45 running Version 6 Unix,
and later on a VAX running 4.2. For a variety of reasons, it would be
extremely painful to port the development environment to the IBM PC.

Any filenames in the source release which are mentioned in this manual will
be given as a pathname relative to the root of the release. Thus the
directory with the telnet source code is @i[srccmd/tn].

For a more user oriented tour of the programs, you should see the user
manual for the programs@cite[usermanual]. A good general introduction to
local area networks can be found in @cite[mcnamara].

Comments made in this manual are not intended to represent the opinion of
MIT or any person there, including possibly the author (depending on his
mood).

Comments @i[about] this manual and suggestions/criticisms are quite welcome
and encouraged.

This manual is available online in the release in the directory
@i[doc/progman]. The user's manual is in @i[man].

@section[Changes to the manual]

Since April 1 1984.

The manual now documents the multiple connection TCP. A chapter on the
development environment has been split out of the chapter on structure.
Documentation has been added on using the UDP time service functions. The
use of lint and the profiler is documented. The serial line framing protocol
section has been fixed so that the tables are readable. Several references
have been changed or added.

The tasking section has been updated to describe the new stack handling
code. The timer section has been updated to describe some new ways of
setting timers, and describes the obscure low level routines that interface
to the BIOS clock. The description of the customizer in the structure section
has finally been updated.

The chapter on TCP now covers Don Gillies' multiple connection TCP. There's
also been a chapter added on USP.

A glossary has been added.

The file @i[doc/change.log] should be consulted for a list of changes to the
various pieces of code.

Since January 1 1985.

A section has been added describing the programming interface for
RCMP.

An appendix has been added describing the printer spooler protocol
used by Berkeley 4.2 Unix.

An appendix describing files in the distribution has also been added.

A chapter was written about programs in the distribution that run
under 4.2 Unix, and interactions between PC/IP and 4.2 Unix.

@section[Credits]

This is a roughly alphabetical list of [known] people who have contributed
to this release in some way:

Larry Allen, David Bridgham, Janice Chung, Dave Clark, Geof Cooper,
Eric Crane, Nancy Crowther, Don Gillies, Wayne Gramlich, Ted Kim, Lou
Konopelski, Mark Lambert, Bede McCall, Marie Macaisa, Drew Perkins,
John Romkey, Mark Rosenstein, Shawn Routhier, Jerome Saltzer, Karen
Sollins, Chris Terman, Muriel Webber, William Westfield, Henry Woo,
Karl Wright
