@part[lprspec, root "progman.mss"]

@appendix[LPR Protocol Description]

This appendix is a description of the Berkeley 4.2 Unix @i[lpr]
protocol. A more terse description can be found in @cite[lpr]. This
description is by no means guaranteed to be complete.

@begin[format]
			THE LPR PROTOCOL
		(as dug out of the code by SAR 1/16/85)

		Check the queue and print any jobs there.

1)	Open a connection to the printer service prot on the spooler
	vax (515) using TCP
		The check for a valid user of the service occurs here.
		It first checks to see if the host is a valid user.
		This is done by looking up the host in /etc/hosts.equiv
		and /etc/hosts.lpd.  It then checks the port number.  A 
		valid port number is less than 1023.  If either of these 
		checks fail it closes the connection and you lose.

2)	Send the command code 
	"\1printer\n" 
		(printer must be less than 1022 characters long)
		This is not used by the machines making use of the
		remote printing functions as far as I can tell.
		Included merely for completeness.

@newpage
			Send A File to the Remote Queue

1)	same as above.

2)	Send the name of the printer your sending a file to.
	"\2printer\n" (printer must be < 1022 characters long)
	
	Responses
	'\0' is ok 
	'\1' indicates an error, one of cannot open printer
		description file, unknown printer, cannot connect to 
		spooling directory, queue is disabled, or stat fails.

3)	Send a command to tell receive what to do.
	"\1\n" bad data sent flush current files and continue from 3.
	"\2size cfilename\n" prepare to receive the control file.
	"\3size dfilename\n" prepare to receive a data file.
		size is the size of the file (in bytes)

	Responses
	'\0' OK ready to receive file.
	'\1' lost connection or protocol mixup, receive flushed, start from 1.
	'\2' not enough room for file of size "size" in spool area,
		this receive flushed, start from 3.

4)	Send the file (their implementation uses 1024 byte blocks). Ending with
	'\0' if the file is good
	nonzero if the file was bad 

	Responses for '\0' case
	'\0' OK file received.
	'\1' lost connection, write errors restart from 1.

	No response for nonzero case restart from 1.

5)	It would seem that the right way to end the transfer (when
	finished) is simply to close the connection.

The way the receiver is set up it expects the data file(s) to be sent
first followed by the control file.  And then maybe more data file(s)
followed by a control file etc.

For the format of the data and control files see the last page.

@newpage
		Displaying the Queue
1)	same as above

2)	send request for the short form of the queue
	"\3printer users jobs\n"

	or for the long form of the queue
	"\4printer users jobs\n"
		where printer is the printer's name
		users are whatever user name are used in the control files
		and jobs are the numbers used in the control and data filnames
		note that users and jobs are limited to 50 apiece and
		are optional

	response
	appears to just do a "remote" print and write the queue to the
		output which in there's just goes into the connection.
	appears to return a string on fatal errors (too many requests
		or users or wrong format)

3)	close the port when nothing else comes out of it.

@newpage
		Removing a file from the queue

1)	same as above

2)	send the command to start the dequeueing
	"\5printer person users jobs\n"
		where printer is the printer's name
		person is the name of the user trying to do this 
		and users and jobs are the same as above (also optional)
	
	response
	sends back lots of strings telling what it is doing, if it can
		access everything it needs to if you can do that etc.
		if it succeeds it sends a list of what it deleted.

3)	again just close the connection when you run out of characters
		coming in.

Notes:
	If person = "-all" then all files from the remote host sending
this are deleted (all is a reserved name in general and should only be
sent by superuser type people class => operators).
	steps through the queue looking at the control files
For each file it checks the owner and the machine name to see if it
this user is allowed to delete this file root is allowed to delete any
file from it's machine either all at once (by using person = "-all") or
one at a time by using the user or request lists.  Random users may
delete only their files sent from their current machine by use of users
or requests numbers.  for each cfile it lets be deleted it also deletes
the files named in the U fields in said cfile.  
	The name of the machine encoded in the c and d filenames must
be equal to the host name that the port calls generate.
	
@newpage
		The Control and Data files

Control File: format is the first character in the line is a command,
the rest of the line is the argument.  Also note lowercase letters
denote the data file names (of various types).

currently valid commands are:

	J -- "job name" on banner page
	C -- "class name" on banner page
        L -- "literal" user's name to print on banner
	T -- "title" for pr
	H -- "host name" of machine where lpr was done
	P -- "person" user's login name
	I -- "indent" amount to indent output
	f -- "file name" name of text file to print
	l -- "file name" text file with control chars
	p -- "file name" text file to print with pr(1)
	t -- "file name" troff(1) file to print
	n -- "file name" ditroff(1) file to print
	d -- "file name" dvi file to print
	g -- "file name" plot(1G) file to print
	v -- "file name" plain raster file to print (impress)
	c -- "file name" cifplot file to print
	1 -- "R font file" for troff
	2 -- "I font file" for troff
	3 -- "B font file" for troff
	4 -- "S font file" for troff
	N -- "name" of file (used by lpq)
	U -- "unlink" name of file to remove
	      (after we print it. (Pass 2 only)).
	M -- "mail" to user when done printing

Currently it looks like only a lowercase filename and U command are
necessary.  However one should also include J, L, H, and P. 

In general the lpd program doesn't care what the data file looks like.
It should however be of the type specified in the control file
otherwise it will probably print incorrectly.

The format is ?fA<number><hostname>.  ? is either c for control or d
for data files.  Number is a 3 digit number (0 padded) used for job
number information.  Hostname is the name of the originating host and
had best be equal to whatever shows up in the from field when a
connection is opened (ie probably should be the "real" hostname).
Currently all of these must be used as the program has them compiled
in. I may change this in time but currently it is the law if you
want everything to work (some things will work just fine without it,
queueing a file just wants names, showing the queue expects a number
to start in the fourth position, deleting a file expects the hostname
to start in the 7th position and go to the end of the filename.

@end[format]
