/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

#include <ip.h>


/*  Procedure to convert the seconds from a network time server, and
    set the PC clock accordingly.  */

/*  Removed bug in days-per-year calculation, 12/31/83. <J.H. Saltzer>
    Readjusted calculation to base on 1/1/81 rather than 1/1/80,
    to simplify leap-year processing and remove a bug that caused
    12/31 to be shown as 1/1 once every four years.  12/31/84.
						 <J. H. Saltzer>  */

#define START	2556144000L	/* seconds between 1/1/1900 and 1/1/1981 */
#define	QUADY	126230400L	/* seconds in four years, including
							one leap day */
#define	YEAR	31536000L	/* seconds in one non-leap year */
#define	DAY	86400L		/* seconds in one day */
#define	HOUR	3600		/* seconds in one hour */
#define	MINUTE	60		/* you guessed it */

int	setdosl();

set_pc_clk(arg)
	long	arg; {	/*  arg is number of seconds since
					 midnight GMT January 1, 1900  */
	int i;
	int nmons;
	int ndate;
	int nquads;	/* Number of completed four-year blocks since START */
	int nyrs;	/* Number of completed years in this block */
	int ndays;	/* Number of this day in this year  */
	int nhrs;	/* Number of completed hours in this day  */
	int nmins;	/* Number of completed minutes in this hour  */
	int nsecs;	/* Residue after removing minutes from offered time */
	long offset;
	char *label;
	long time;
	static	int	days[12] = {31,28,31,30,31,30,31,31,30,31,30,31};

	label = custom.c_tmlabel;
	offset = custom.c_tmoffset*60L;
	time = arg - START;	/*  move to 1981, to eliminate sign bit.*/
	time = time - offset;	/*  move to local time before figuring date.*/
	nyrs = 0;
	nquads = 0;
	ndays = 1;		/*  Note that dates are one-origin */
	nmins = 0;		/*  But minutes and hours are zero-origin */
	nhrs = 0;
	while( time  >= QUADY )
		{ time = time - QUADY;
		  ++nquads; }
	/*  Can't use while() here because fourth year is longer.  */
	if( time >= YEAR ) { time = time - YEAR; ++nyrs; }
	if( time >= YEAR ) { time = time - YEAR; ++nyrs; }
	if( time >= YEAR ) { time = time - YEAR; ++nyrs; }

	while( time >= DAY )
		{ time = time - DAY;
		  ++ndays; }

	while( time >= HOUR )
		{ time = time - HOUR;
		  ++nhrs; }

	while( time >= MINUTE )
		{ time = time - MINUTE;
		  ++nmins; }

	if(NDEBUG & APTRACE)
		printf ("4yrs %u, Yrs %u, Days %u, Hrs %u, Mins %u\n",
				nquads, nyrs, ndays, nhrs, nmins);
	if (nyrs == 3) days[1]++;
	for( i = 0; ndays > days[i]; i++) ndays = ndays - days[i];
	nmons = i+1;
	ndate = ndays;
	nyrs = nyrs + 4*nquads + 1981;
	nsecs = time;

	if ( setdosl( 0x2B, nyrs, (nmons*256 + ndate )) == 0 )
		printf("setting ");
		else printf("unable to set ");
	printf("date to %d/%d/%02d\n", nmons, ndate, nyrs-1900 );
	if ( setdosl( 0x2D, (nhrs*256 + nmins), nsecs*256) == 0 )  
		printf("setting ");
		else printf ("unable to set");  
	printf("time to %02u:%02u:%02u %s\n", nhrs, nmins, nsecs,
							label);
	return;
	}
