@chapter[The Ethernet Driver]

This chapter describes the ethernet driver for the 3COM ethernet board. The
essential references are @cite[3com2], @cite[dma], @cite[intcont1] and
@cite[intcont2]. Unfortunately, specs sheets do not tend to be eminently
readable, and each of the ethernet board, DMA controller and interrupt
controller has its own quirks.

The code is riddled with @i[#ifdef]s to allow to fairly different drivers to
use the same base code. One driver is the normal ethernet driver which sends
and receives packets, used by most programs. The second driver is used by
the netwatch program. It wants to receive all packets and only copy a few
bytes from each packet (the source and destination addresses, the packet
type and several bytes of data).

@section(Include Files and Libraries)

The important include files are @i[<ether.h>], @i[<int.h>], @i[<dma.h>] and
@i["ether/ether.h"] (which is in the home directory of the ethernet driver.
The file @i[<ether.h>] declares some constants used in initialization of the
driver. The @i[<int.h>] and @i[<dma.h>] files declare some constants useful
in dealing with the interrupt controller and DMA controller. They actually
are very incomplete and only have ones which I needed for the ethernet
driver.  Finally, the @i[srclib/ether/ether.h] file has all sorts of
constants used for poking at the ethernet board, some state variable values,
a macro for copying ethernet addresses and the ethernet packet types used
for Internet packets and Plummer Address Resolution Packets.

The ethernet code is available in the @i(-lether) library. The netwatch
compatible version of the driver is in the @i[-lwether] library.

@section[Encapsulation of Internet Packets on the Ethernet]

Internet packets are transmitted header first over the ethernet, in what
seems to be the most straightforward way possible. This network driver will
not understand Berkeley trailers. Also, the ethernet packet type used for
internet packets is 0x800. The ethernet packet type for address resolution
packets is 0x806. These types were chosen based on information supplied by
Jon Postel and David Plummer. This encapsulation technique is as specified
in @cite[ether-encaps].

@section(Configuration)

There is a configuration file associated with each net interface driver. For
the 3COM ethernet driver, the file is @i[srclib/ether/enet.c].  The file
declares an array of structures called @i[nets] of. This routine initializes
the @i(NET) struct associated with the ethernet interface. In older
releases, there was a routine called @i[Init1()] which did the
initialization but it's better to have the structure statically initialized.
If there is any part of the structure which can't be initialized statically,
the driver's initialization routine can complete the work.

@begin(group)
@begin(verbatim)

int et@us()init(), et@us()send(), et@us()stat(), et@us()close();

int Nnet = 1;

NET nets[1] = { "Ethernet", et@us()init, et@us()send, 0, et@us()close, 0, 0,
		0, 0, 1400, 14, 0, 0L, et@us()stat, 0L, &custom };

@end(verbatim)
@end(group)

The routine basically sets up the name of the interface (for debugging
purposes), several entry points for it, the stack size, and several
parameters about the ethernet (such as the length of the local net header).

If a program were to be configured for multiple net interfaces, it would
have to have a special configuration file.

@section(Initialization)

The function @i[et@us2()init()] performs the initialization of the ethernet
card and driver. It forks the ethernet task and puts the ethernet interrupt
handler in place. The interrupt vector, base I/O address and DMA channel of
the interface are all configurable. The ethernet driver gets these values
from the custom structure associated with its ethernet interface.

The first parameter of @i[et@us2()init()] is used to indicate what mode the
interface should be initialized in. The options are @i[LOOPBACK],
@i[ALLPACK], and @i[MULTI] which cause the ethernet interface to enter
loopback mode, to receive all packets (enter "promiscuous" mode), or receive
multicast packets. The ethernet driver does not actually support multicast
packet reception properly, but it could be changed to do so.

To initialize the ethernet interface, @i[et@us2()init()] resets it, and
initializes the 8259A@footnote(The interrupt controller.). Then it reads
the hardware address from the board and writes it back to the board. If
@i(INFOMSG) is enabled as a debugging mode, the ethernet address will be
displayed in hexadecimal. Then the transmitter is enabled to detect all
errors, and the receiver is enabled in the mode specified by the first
parameter.

@section[Ethernet Driver Problems]

A number of problems were encountered when trying to get the ethernet driver
to run properly on the IBM AT. The problems all stemmed from lost
interrupts. The final version of the driver is very much rewritten. It now
uses a single interrupt, when a packet is received. It's not clear whether
the problems were hardware or software, the AT or the 3COM card, but the
fact that they happened should be recorded somewhere.
