# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 * Copyright (c) 1989 Jan-Simon Pendry
 * Copyright (c) 1989 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	%W% (Berkeley) %G%
 *
 * $Id: fsi_lex.l,v 5.2.2.1 1992/02/09 15:09:36 jsp beta $
 *
 */

/*
 * Lexical analyzer for fsinfo.
 * TODO: Needs rewriting.
 */

static int xinput();
static void xunput();

#ifdef FLEX_SCANNER
static int yylineno;
/* Flex support with help from Vern Paxson <vern@helios.ee.lbl.gov> */
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size)		\
{						\
	int i;					\
	for (i = 0; i < max_size; i++) {	\
		int ch = xinput(i == 0);	\
		if (ch == 0)			\
			break;			\
		buf[i] = ch;			\
	}					\
	result = i;				\
}

#define	INIT_STATE {				\
		switch ((yy_start - 1) / 2) {	\
		case 0:				\
			BEGIN F;		\
			break;			\
		}				\
}


#else
/*
 * Using old lex...
 */
#undef unput
#define unput(ch) xunput(ch)
#undef input
#define input() xinput(1)

#define	INIT_STATE {				\
		switch (yybgin - yysvec - 1) {	\
		case 0:				\
			BEGIN F;		\
			break;			\
		}				\
}

#endif /* FLEX_SCANNER */

#include "../fsinfo/fsinfo.h"
#include "fsi_gram.h"
#include <ctype.h>

static char *filename;
static char *optr;
static char ostr[1024];
static find_resword();
static unsigned char ibuf[64];
static unsigned char *iptr = ibuf;
static int quoted;
static int lastch, nextch = '\n';
YYSTYPE yylval;

struct r {
	char *rw;
	int tok;
} rr[] = {
	{ "->", tEQ },
	{ "arch", tARCH },
	{ "as", tAS },
	{ "automount", tAUTOMOUNT },
	{ "cluster", tCLUSTER },
	{ "config", tCONFIG },
        { "direct", tDIRECT },
	{ "dumpset", tDUMPSET },
	{ "exportfs", tEXPORTFS },
	{ "freq", tFREQ },
	{ "from", tFROM },
	{ "fs", tFS },
	{ "fstype", tFSTYPE },
	{ "host", tHOST },
	{ "hwaddr", tHWADDR },
	{ "inaddr", tINADDR },
	{ "localhost", tLOCALHOST },
	{ "log", tLOG },
	{ "mount", tMOUNT },
	{ "netif", tNETIF },
	{ "netmask", tNETMASK },
        { "nfsalias", tNFSEQ },
	{ "opts", tOPTS },
	{ "os", tOS },
	{ "passno", tPASSNO },
	{ "sel", tSEL },
	{ "volname", tVOLNAME },
	{ 0, 0 },
};
#define	NRES_WORDS (sizeof(rr)/sizeof(rr[0])-1)

# define F 2
# define Q 4
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
	INIT_STATE;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{ return find_resword(yytext); }
break;
case 2:
	;
break;
case 3:
		{ yylineno++; }
break;
case 4:
	{ return *yytext; }
break;
case 5:
		{ BEGIN Q; optr = ostr; quoted = 1; }
break;
case 6:
		{ yylineno++; yyerror("\" expected"); BEGIN F; }
break;
case 7:
		{ *optr++ = '\b'; /* escape */ }
break;
case 8:
		{ *optr++ = '\t'; /* escape */ }
break;
case 9:
		{ *optr++ = '\"'; /* escape */ }
break;
case 10:
		{ *optr++ = '\\'; /* escape */ }
break;
case 11:
		{ yylineno++; /* continue */ }
break;
case 12:
		{ *optr++ = '\r'; /* escape */ }
break;
case 13:
		{ *optr++ = '\n'; /* escape */ }
break;
case 14:
		{ *optr++ = '\f'; /* escape */ }
break;
case 15:
	{ *optr++ = ' '; /* force space */ }
break;
case 16:
		{ yyerror("Unknown \\ sequence"); }
break;
case 17:
{ char *p = (char *) yytext-1; while (p = strchr(p+1, '\n')) yylineno++; }
break;
case 18:
		{ BEGIN F; quoted = 0;
				*optr = '\0';
				yylval.s = strdup(ostr);
				return tSTR;
			}
break;
case 19:
		{ *optr++ = *yytext; }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

static int find_resword(s)
char *s;
{
	int tok = 0;

	int l = 0, m = NRES_WORDS/2, h = NRES_WORDS-1;
	int rc = 0;
	
	m = NRES_WORDS/2;

#define FSTRCMP(p, q) ((*(p) == *(q)) ? strcmp((p)+1, (q)+1) : *(p) - *(q))

	while ((l <= h) && (rc = FSTRCMP(s, rr[m].rw))) {
		/*fprintf(stderr, "failed to cmp(%s, %s), %d, %d, %d\n", s, rr[m].rw, l, m, h);*/
		if (rc < 0)
			h = m - 1;
		else
			l = m + 1;
		m = (h + l) / 2;
	}

	if (rc == 0)
		tok = rr[m].tok;

	switch (tok) {
	case tLOCALHOST:
		s = "${host}";
		/* fall through... */
	case 0:
		yylval.s = strdup(s);
		tok = tSTR;
		/* fall through... */
	default:
		return tok;
	}

}

int yyerror(s, s1, s2, s3, s4)
char *s;
char *s1, *s2, *s3, *s4;
{
	col_cleanup(0);
	fprintf(stderr, "%s:%d: ", filename ? filename : "/dev/stdin", yylineno);
	fprintf(stderr, s, s1, s2, s3, s4);
	fputc('\n', stderr);
	parse_errors++;
}

ioloc *current_location()
{
	ioloc *ip = ALLOC(ioloc);
	ip->i_line = yylineno;
	ip->i_file = filename;
	return ip;
}

#ifdef FLEX_SCANNER
#undef yywrap
#endif

int yywrap()
{
static int first = 1;
	if (first) {
		char prog[16*1024];
		strcpy(prog, "for file in ");
		while (*++g_argv) {
			if (access(*g_argv, 4) < 0) {
				error("\"%s\": Cannot open for reading", *g_argv);
				file_io_errors++;
			} else {
				strcat(prog, *g_argv);
				strcat(prog, " ");
			}
		}
		strcat(prog, "; do /lib/cpp ");
		strcat(prog, idvbuf);
		strcat(prog, " -DHOSTNAME=\'");
		strcat(prog, hostname);
		strcat(prog, "\' \"$file\"; done");
		yyin = popen(prog, "r");
		if (yyin) {
			/*if (filename) free(filename);*/
			filename = strdup("unknown");
			yylineno = 1;
			first = 0;
			return 0;
		} else {
			perror(prog);
		}
	}

	if (!first && yyin && pclose(yyin) != 0)
		parse_errors++;

	return 1;
}

#define xgetc(fp) ((iptr > ibuf) ? (*--iptr) : (lastch = nextch, nextch = getc(fp), (nextch == EOF ? nextch = lastch, EOF : nextch)))

static int xinput(need)
int need;
{
static int c_comment = 0;
	int ch, ch2;

	do {
		ch = xgetc(yyin);
		/* fprintf(stderr, "ch = %c, %#x, %d\n", ch, ibuf,iptr-ibuf); */
		if (ch == EOF) return 0;
		if (quoted)
			return ch;
		if (c_comment) {
			ch2 = ch;
			do {
				if (ch2 == '\n') {
					nextch = '\n';
					return ch2;
				}
				/* C style comment */
				do {
					ch2 = getc(yyin);
					if (ch2 == '\n') {
						nextch = '\n';
						return ch2;
					}
				} while (ch2 != '*' && ch2 != EOF);

				while (ch2 == '*')
					ch2 = getc(yyin);
			} while (ch2 != '/' && ch2 != EOF);
			c_comment = 0;
			if (ch2 == EOF)
				break;
			continue;
		}

		if (ch == '#') {
			/*log("lastch = '%c' (%#x)", lastch, lastch);*/
			if (lastch == '\n') {
				char fname[MAXPATHLEN];
				char *fptr;
				if (!need) {
					xunput('#');
					nextch = '\n';
					return 0;
				}
				fname[0] = '\0';
				/* Skip past space */
				do {
					ch2 = getc(yyin);
				} while (ch2 != EOF && ch2 != '\n' && !isdigit(ch2));
				if (isdigit(ch2)) {
					/* Read in line number */
					fptr = fname;
					do {
						*fptr++ = ch2;
						ch2 = getc(yyin);
					} while (isdigit(ch2));
					*fptr = '\0';
					if (fptr != fname)
						yylineno = atoi(fname) - 1;
				}
				/* Skip past space */
				while (ch2 != EOF && ch2 != '\"' && ch2 != '\n')
					ch2 = getc(yyin);
				if (ch2 == '\"') {
					/* Read file name */
					fptr = fname;
					ch2 = getc(yyin);
					while (ch2 != '\"' && ch2 != EOF && ch2 != EOF) {
						*fptr++ = ch2;
						ch2 = getc(yyin);
					}
					*fptr = '\0';
					if (fname[0]) {
						log("Setting filename to \"%s\"", fname);
						/*if (filename) free(filename);*/
						filename = strdup(fname);
					}
				}
				while (ch2 != '\n' && ch2 != EOF)
					ch2 = getc(yyin);
			} else do {
				ch2 = getc(yyin);
			} while (ch2 != '\n' && ch2 != EOF);
			if (ch2 == '\n') {
				nextch = '\n';
				return ch2;
			}
		} else if (ch == '/') {
			ch2 = getc(yyin);
			if (ch2 == '/') {
				/* C++ style comment */
				do {
					ch2 = getc(yyin);
				} while (ch2 != '\n' && ch2 != EOF);
				if (ch2 == '\n') {
					nextch = '\n';
					return ch2;
				}
			} else if (ch2 == '*') {
				c_comment = 1;
				continue;
			} else {
				xunput(ch2);
				return ch;
			}
		} else {
			return ch;
		}
	} while (ch2 != EOF);
	error("End of file within comment");
	return 0;
}

static void xunput(c)
int c;
{
	if (c && c != EOF) {
		if (iptr == ibuf + sizeof(ibuf) - 1)
		 	fatal("Out of space in lexical pushback");
		*iptr++ = c;
	}
}
int yyvstop[] = {
0,

1,
0,

2,
0,

3,
0,

5,
0,

4,
0,

19,
0,

19,
0,

6,
0,

18,
19,
0,

19,
0,

17,
0,

16,
0,

11,
0,

15,
16,
0,

9,
16,
0,

10,
16,
0,

7,
16,
0,

14,
16,
0,

13,
16,
0,

12,
16,
0,

8,
16,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	3,7,	0,0,	
5,12,	0,0,	0,0,	7,7,	
0,0,	0,0,	3,8,	3,9,	
5,13,	5,14,	18,17,	7,0,	
7,0,	16,19,	13,17,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	16,19,	16,20,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	3,10,	
0,0,	5,15,	7,0,	0,0,	
7,0,	13,17,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
16,21,	0,0,	16,22,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	3,11,	0,0,	
5,12,	0,0,	0,0,	7,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	16,19,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	6,16,	0,0,	5,16,	
0,0,	0,0,	0,0,	0,0,	
0,0,	13,18,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
16,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	16,24,	0,0,	
0,0,	0,0,	16,25,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	16,26,	0,0,	
0,0,	7,0,	16,27,	7,0,	
16,28,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+0,	0,		0,	
yycrank+0,	0,		0,	
yycrank+-1,	0,		0,	
yycrank+0,	yysvec+3,	0,	
yycrank+-3,	0,		0,	
yycrank+-1,	yysvec+5,	0,	
yycrank+-6,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+0,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+9,
yycrank+0,	0,		yyvstop+11,
yycrank+9,	0,		yyvstop+13,
yycrank+0,	0,		yyvstop+15,
yycrank+0,	0,		yyvstop+17,
yycrank+-16,	0,		yyvstop+20,
yycrank+0,	yysvec+13,	yyvstop+22,
yycrank+4,	0,		0,	
yycrank+0,	0,		yyvstop+24,
yycrank+0,	yysvec+13,	yyvstop+26,
yycrank+0,	0,		yyvstop+28,
yycrank+0,	0,		yyvstop+31,
yycrank+0,	0,		yyvstop+34,
yycrank+0,	0,		yyvstop+37,
yycrank+0,	0,		yyvstop+40,
yycrank+0,	0,		yyvstop+43,
yycrank+0,	0,		yyvstop+46,
yycrank+0,	0,		yyvstop+49,
0,	0,	0};
struct yywork *yytop = yycrank+132;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,'=' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,'=' ,01  ,'=' ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/* #ident	"@(#)libl:lib/ncform	1.3" */
#ident	"$Header: ncform,v 1.4.3.1 89/11/28 09:46:41 wje Exp $"
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
