/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1990 MIPS Computer Systems, Inc.            |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 52.227-7013.   |
 * |         MIPS Computer Systems, Inc.                       |
 * |         928 Arques Avenue                                 |
 * |         Sunnyvale, CA 94086                               |
 * |-----------------------------------------------------------|
 */
/* $Header: unistd.h,v 1.7.3.2 90/05/10 01:06:09 wje Exp $ */

#ifndef	_UNISTD_
#define	_UNISTD_	1


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* Symbolic constants for the "access" routine: */
#define	R_OK	4	/* Test for Read permission */
#define	W_OK	2	/* Test for Write permission */
#define	X_OK	1	/* Test for eXecute permission */
#define	F_OK	0	/* Test for existence of File */

#define F_ULOCK	0	/* Unlock a previously locked region */
#define F_LOCK	1	/* Lock a region for exclusive use */
#define F_TLOCK	2	/* Test and lock a region for exclusive use */
#define F_TEST	3	/* Test a region for other processes locks */


/* Symbolic constants for the "lseek" routine: */
#define	SEEK_SET	0	/* Set file pointer to "offset" */
#define	SEEK_CUR	1	/* Set file pointer to current plus "offset" */
#define	SEEK_END	2	/* Set file pointer to EOF plus "offset" */

/* Path names: */
#define	GF_PATH	"/etc/group"	/* Path name of the "group" file */
#define	PF_PATH	"/etc/passwd"	/* Path name of the "passwd" file */


#if defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__)
extern void _exit (int);
extern int access (const char *, int);
extern unsigned int alarm (unsigned int);
extern int chdir (const char *);
extern int chown (const char *, unsigned short , unsigned short );
extern int close (int);
extern char * ctermid (char *);
extern char * cuserid (char *);
extern int dup (int);
extern int dup2 (int, int);
extern int execl (const char *, const char *, ...);
extern int execle (const char *, const char *, ...);
extern int execlp (const char *, const char *, ...);
extern int execv (const char *, char *const *);
extern int execve (const char *, char *const *, char *const *);
extern int execvp (const char *, char *const *);
extern int fork (void);
extern long int fpathconf (int, int);
extern char * getcwd (char *, __SIZE_TYPE__ );
extern unsigned short getegid (void);
extern unsigned short geteuid (void);
extern unsigned short getgid (void);
extern char * getlogin (void);
extern int getopt (int, char *const *, const char *);
extern int getpgrp (void);
extern int getpid (void);
extern int getppid (void);
extern unsigned short getuid (void);
extern int isatty (int);
extern int link (const char *, const char *);
extern long lseek (int, long , int);
extern long int pathconf (const char *, int);
extern int pause (void);
extern int pipe (int *);
extern int read (int, void *, __SIZE_TYPE__ );
extern int rmdir (const char *);
extern int setgid (unsigned short );
extern int setpgid (int , int );
extern int setsid (void);
extern int setuid (unsigned short );
extern unsigned int sleep (unsigned int);
extern long int sysconf (int);
extern int tcgetpgrp (int);
extern int tcsetpgrp (int, int );
extern char * ttyname (int);
extern int unlink (const char *);
extern int write (int, const void *, __SIZE_TYPE__ );
#endif /* defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__*/
#endif
