/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1990 MIPS Computer Systems, Inc.            |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 52.227-7013.   |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Drive                                |
 * |         Sunnyvale, CA 94086                               |
 * |-----------------------------------------------------------|
 */
/* $Header: UilDef.h,v 4.1.1.2 90/12/26 15:19:10 mar Exp $ */
#ifdef REV_INFO
#ifndef lint
static char SCCSID[] = "OSF/Motif: @(#)UilDef.h	3.13 90/07/27";
#endif /* lint */
#endif /* REV_INFO */

/******************************************************************************
*******************************************************************************
*
*  (c) Copyright 1989, 1990, OPEN SOFTWARE FOUNDATION, INC.
*  (c) Copyright 1989, 1990, DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
*  ALL RIGHTS RESERVED
*  
*  	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED
*  AND COPIED ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND
*  WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR
*  ANY OTHER COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE
*  AVAILABLE TO ANY OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF THE
*  SOFTWARE IS HEREBY TRANSFERRED.
*  
*  	THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
*  NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY OPEN SOFTWARE
*  FOUNDATION, INC. OR ITS THIRD PARTY SUPPLIERS  
*  
*  	OPEN SOFTWARE FOUNDATION, INC. AND ITS THIRD PARTY SUPPLIERS,
*  ASSUME NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE ANY OF ITS
*  SOFTWARE .   OSF SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
*  KIND, AND OSF EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING
*  BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*  FITNESS FOR A PARTICULAR PURPOSE.
*  
*  Notice:  Notwithstanding any other lease or license that may pertain to,
*  or accompany the delivery of, this computer software, the rights of the
*  Government regarding its use, reproduction and disclosure are as set
*  forth in Section 52.227-19 of the FARS Computer Software-Restricted
*  Rights clause.
*  
*  (c) Copyright 1989, 1990, Open Software Foundation, Inc.  Unpublished - all
*  rights reserved under the Copyright laws of the United States.
*  
*  RESTRICTED RIGHTS NOTICE:  Use, duplication, or disclosure by the
*  Government is subject to the restrictions as set forth in subparagraph
*  (c)(1)(ii) of the Rights in Technical Data and Computer Software clause
*  at DFARS 52.227-7013.
*  
*  Open Software Foundation, Inc.
*  11 Cambridge Center
*  Cambridge, MA   02142
*  (617)621-8700
*  
*  RESTRICTED RIGHTS LEGEND:  This computer software is submitted with
*  "restricted rights."  Use, duplication or disclosure is subject to the
*  restrictions as set forth in NASA FAR SUP 18-52.227-79 (April 1985)
*  "Commercial Computer Software- Restricted Rights (April 1985)."  Open
*  Software Foundation, Inc., 11 Cambridge Center, Cambridge, MA  02142.  If
*  the contract contains the Clause at 18-52.227-74 "Rights in Data General"
*  then the "Alternate III" clause applies.
*  
*  (c) Copyright 1989, 1990, Open Software Foundation, Inc.
*  ALL RIGHTS RESERVED 
*  
*  
* Open Software Foundation is a trademark of The Open Software Foundation, Inc.
* OSF is a trademark of Open Software Foundation, Inc.
* OSF/Motif is a trademark of Open Software Foundation, Inc.
* Motif is a trademark of Open Software Foundation, Inc.
* DEC is a registered trademark of Digital Equipment Corporation
* DIGITAL is a registered trademark of Digital Equipment Corporation
* X Window System is a trademark of the Massachusetts Institute of Technology
*
*******************************************************************************
******************************************************************************/

/*
**++
**  FACILITY:
**
**      User Interface Language Compiler (UIL)
**
**  ABSTRACT:
**
**      This include file defines the set of definitions used by all of
**	modules of the UIL compiler.
**
**--
**/

#ifndef UilDef_h
#define UilDef_h


/*
**
**  INCLUDE FILES
**
**/

#include <Mrm/Mrm.h>

/*
**                                    
**  Universal Definitions
**
*/

#define _compiler_version "V2.0-000"
#define _compiler_version_int 2
#define _data_version 2
#define _host_compiler "Motif Uil Compiler"

#ifdef NULL
#undef NULL
#endif
		#undef NULL
#define NULL	  	0

#ifdef TRUE
#undef TRUE
#endif
#define TRUE	 	1

#ifdef FALSE
#undef FALSE
#endif
#define FALSE	  	0

#define debug_version	FALSE

#define NOSTRING_DIRECTION 2

#define k_normal  	1
#define k_error   	0

typedef int status;
typedef int boolean;

/*
**  Leave out const attribute until fixed in C compiler
*/

#define const

/*
**
**  Constants controlling limits in the compiler
**
*/

#define src_k_max_source_files		101
#define src_k_max_source_line_length	132
#define lex_k_unprint_sub		'?'
#define sym_k_max_list_count		1000
#define sym_k_max_color_count		256
#define Uil_k_max_include_dir_count	32

/*
**
**  Definition of Compiler Termination Statuses
**
*/

#define uil_k_min_status	Uil_k_min_status
#define uil_k_success_status	Uil_k_success_status
#define uil_k_info_status	Uil_k_info_status
#define uil_k_warning_status	Uil_k_warning_status
#define uil_k_error_status	Uil_k_error_status
#define uil_k_severe_status	Uil_k_severe_status
#define uil_k_max_status	Uil_k_max_status


/*
**
**  Macros to access bit vectors
**
*/

/* MOVED TO DBDef.h */


/*
**
**  Upper and Lower Case Translation Macros
**
*/

#define _upper(c)	((c) >= 'a' && (c) <= 'z' ? (c) & 0x5F:(c))
#define _lower(c)	((c) >= 'A' && (c) <= 'Z' ? (c) | 0x20:(c))


/*
**
**  Assert Macro
**
*/

#if debug_version
#define _assert( __condition, __text )			\
	if (!(__condition))				\
	{  diag_issue_internal_error( (__text)); }
#else
#define _assert( __condition, __text )			\
	if (!(__condition))				\
	{  diag_issue_internal_error( NULL ); }
#endif

/*
**
**  Macros for setting overflow detection
**
*/







#define _catch_overflow( _env_block, _error_label) \
	{ int	    _setting;			\
	  _setting = 1;			     \
	  uil_az_error_env_block = _env_block; \
	  if( setjmp( _env_block ) != 0 )    \
		goto _error_label;	    \
	}

#define _reset_overflow \
        { uil_az_error_env_block = NULL; }

/*
**
**  _error and _okay macro
**
*/

#define _error( __status )	\
	((__status & 1)==0)

#define _success( __status )	\
	((__status & 1)==1)


/*
**
**  Memory allocation definitions
**
*/

#define _get_memory XtMalloc

#define _free_memory XtFree

/*
**
**  Move macro
**
*/

#define _move memcpy

/*
**
**  Compare macro
**
*/

#define _compare strcmp

/*
**
**  Fill macro
**
*/

#define _fill memset

/*
**
**  Index macro
**
*/

#define _index( __char, __string, __len ) \
    ((int)((char *)memchr( __string, __char, __len ) - (char *)__string ))


/*
**
**  Debug output macro
**
*/
#if debug_version
#define _debug_output lst_debug_output
#else
#define _debug_output printf
#endif


/*
**
** Common includes needed by most modules
**
*/
#include "Uil.h"
#include "UilDBDef.h"                      /* for binary database */
#include "UilMess.h"
#include "UilSymDef.h"			/* must come before UilKeyDef.h */
#include "UilSrcDef.h"			/* must come before UilIODef.h */
#include "UilIODef.h"
#include "UilDiagDef.h"
#include "UilSarDef.h"
#include "UilLexPars.h"
#include "UilCmdDef.h"
#include "UilLexDef.h"

/*
** Global declarations
*/
#include "UilSymGl.h"
#include "UilCompGl.h"


/*
** Function declarations not defined elsewhere
*/
#ifndef _NO_PROTO
#define _ARGUMENTS(arglist) arglist
#else
#define _ARGUMENTS(arglist) ()
#endif

/* uilcmd.c */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern void diag_issue_diagnostic  
	_ARGUMENTS(( int d_message_number , 
		    src_source_record_type *az_src_rec ,
		    int l_start_column, ... ));
extern void lst_debug_output  _ARGUMENTS(( char *format, ... ));


void cmd_decode_command_line  _ARGUMENTS(( int l_arg_count , char *rac_arg_value []));

/* uildiags.c */
extern void diag_issue_summary  _ARGUMENTS(( void ));
extern char *diag_tag_text  _ARGUMENTS(( int const b_tag ));
extern char *diag_object_text  _ARGUMENTS(( int const b_type ));
extern char *diag_value_text  _ARGUMENTS(( int const b_type ));
extern char *diag_charset_text  _ARGUMENTS(( int const b_type ));
extern void diag_initialize_diagnostics  _ARGUMENTS(( void ));
extern void diag_reset_overflow_handler  _ARGUMENTS(( void ));
extern void diag_handler  _ARGUMENTS(( int l_error ));
extern void diag_issue_internal_error  _ARGUMENTS(( char *error_text ));
extern void write_msg_to_standard_error  _ARGUMENTS(( const int message_number , const char *src_buffer , const char *ptr_buffer , const char *msg_buffer , const char *loc_buffer ));
extern char *diag_get_message_abbrev  _ARGUMENTS(( int d_message_number ));
extern void write_msg_to_standard_error  _ARGUMENTS(( const int message_number , const char *src_buffer , const char *ptr_buffer , const char *msg_buffer , const char *loc_buffer ));
extern char *diag_get_message_abbrev  _ARGUMENTS(( int d_message_number ));
extern void diag_report_status  _ARGUMENTS(( void ));

/* uilkeytab.c */
extern key_keytable_entry_type *key_find_keyword  _ARGUMENTS(( unsigned int symbol_length , char *symbol_ptr ));
extern void key_initialize  _ARGUMENTS(( void ));

/* uillexana.c */
extern int yylex  _ARGUMENTS(( void ));
extern void lex_initialize_analyzer  _ARGUMENTS(( void ));
extern void Uil_lex_cleanup_analyzer  _ARGUMENTS(( void ));
extern void lex_issue_error  _ARGUMENTS(( int restart_token ));
extern void issue_control_char_diagnostic  _ARGUMENTS(( unsigned char c_char ));
extern void lex_filter_unprintable_chars  _ARGUMENTS(( char *buffer , int length , unsigned long flags ));
extern long cvt_ascii_to_long  _ARGUMENTS(( unsigned char const *c_text ));
extern sym_value_entry_type *create_str_entry  _ARGUMENTS(( int l_size , int l_charset , sym_value_entry_type *az_charset_entry ));

/* uillstlst.c */
extern void lst_open_listing  _ARGUMENTS(( void ));
extern void Uil_lst_cleanup_listing  _ARGUMENTS(( void ));
extern status create_listing_file  _ARGUMENTS(( uil_fcb_type *az_fcb ));
extern void lst_output_line  _ARGUMENTS(( char *ac_line , boolean v_new_page ));
extern char *current_time  _ARGUMENTS(( void ));
extern void lst_output_listing  _ARGUMENTS(( void ));
extern void lst_output_messages  _ARGUMENTS(( src_message_item_type *az_message_item ));
extern void lst_output_machine_code  _ARGUMENTS(( src_source_record_type *az_src_rec ));
extern void lst_output_message_ptr_line  _ARGUMENTS(( src_source_record_type *az_src_rec , char *src_buffer ));

/* uillstmac.c */
extern void save_widget_machine_code  _ARGUMENTS(( sym_widget_entry_type *widget_entry , URMResourceContext *az_context ));
extern void unload_stack  _ARGUMENTS(( char *rec , int rec_size , src_source_record_type *az_src_rec ));
extern void save_value_machine_code  _ARGUMENTS(( sym_value_entry_type *value_entry , URMResourceContext *az_context ));
extern void save_module_machine_code  _ARGUMENTS(( src_source_record_type *az_src_rec , URMResourceContext *az_context ));
extern void off_put  _ARGUMENTS(( unsigned short off_type , unsigned short off_offset ));
extern void off_get  _ARGUMENTS(( unsigned short *off_type , unsigned short *off_offset ));
extern char *type_from_code  _ARGUMENTS(( MrmType type_code ));
extern char *access_from_code  _ARGUMENTS(( MrmFlag access_code ));
extern char *group_from_code  _ARGUMENTS(( MrmGroup group_code ));
extern void format_arg_value  _ARGUMENTS(( RGMArgValuePtr argval_ptr , char *buffer ));
extern char *class_name_from_code  _ARGUMENTS(( MrmCode mrm_class ));
extern char *resource_name_from_code  _ARGUMENTS(( MrmCode resource ));

/* uilmain.c */
extern void uil_exit  _ARGUMENTS(( int severity ));
extern Uil_status_type Uil _ARGUMENTS((Uil_command_type
*comand_desc,Uil_compile_desc_type *compile_desc,Uil_continue_type
(*message_cb)(), char *message_data, Uil_continue_type (*status_cb)(),
char *status_data));


/* uilp2out.c */
extern void sem_output_uid_file  _ARGUMENTS(( void ));
extern void push  _ARGUMENTS(( sym_entry_type *sym_entry ));
extern sym_entry_type *pop  _ARGUMENTS(( void ));
extern void out_emit_widget  _ARGUMENTS(( sym_widget_entry_type *widget_entry ));
extern void extract_subtree_control  _ARGUMENTS(( sym_list_entry_type *list_entry , sym_control_entry_type **menu_entry , int *count ));
extern void extract_create_callback  _ARGUMENTS(( sym_list_entry_type *list_entry , sym_callback_entry_type **create_entry ));
extern void process_all_callbacks  _ARGUMENTS(( sym_list_entry_type *list_entry , int *arglist_index ));
extern void process_all_arguments  _ARGUMENTS(( sym_list_entry_type *list_entry , int *arglist_index , int *related_count ));
extern void process_all_controls  _ARGUMENTS(( sym_list_entry_type *list_entry , int *widget_index ));
extern void out_emit_value  _ARGUMENTS(( sym_value_entry_type *value_entry ));
extern void emit_callback  _ARGUMENTS(( sym_callback_entry_type *callback_entry , int *arglist_index , boolean emit_create ));
extern void emit_callback_procedures _ARGUMENTS(( sym_proc_ref_entry_type *proc_ref_entry_next, int proc_ref_index, MrmOffset callback_offset ));
extern int count_proc _ARGUMENTS(( sym_list_entry_type *proc_list, int count));
extern void emit_argument  _ARGUMENTS(( sym_argument_entry_type *argument_entry , int arglist_index , int *related_arg_count ));
extern void emit_control  _ARGUMENTS(( sym_control_entry_type *control_entry , int control_offset ));
extern MrmCode ref_value  _ARGUMENTS(( sym_value_entry_type *value_entry , MrmCode *arg_type , int *arg_value , MrmCode *arg_access , char **arg_index , MrmResource_id *arg_id , MrmCode *arg_group ));
extern MrmCode ref_control  _ARGUMENTS(( sym_control_entry_type *control_entry , MrmCode *access , char **index , MrmResource_id *id ));
extern void issue_urm_error  _ARGUMENTS(( char *problem ));
extern MrmCode Urm_code_from_uil_type  _ARGUMENTS(( int uil_type ));
extern int compute_color_table_size  _ARGUMENTS(( sym_value_entry_type *table_entry ));
extern void create_color_table  _ARGUMENTS(( sym_value_entry_type *table_entry , char *buffer ));
extern int compute_icon_size  _ARGUMENTS(( sym_value_entry_type *icon_entry ));
extern void create_icon  _ARGUMENTS(( sym_value_entry_type *icon_entry , char *buffer ));
extern int compute_list_size  _ARGUMENTS(( sym_list_entry_type *list_entry , int type ));
extern void create_int_compression_codes  _ARGUMENTS(( void ));
extern void create_ext_compression_codes  _ARGUMENTS(( void ));

/* uilp2reslv.c */
extern void sem_resolve_forward_refs  _ARGUMENTS(( void ));

/* uilsarcomp.c */
extern sym_value_entry_type *sem_create_cstr  _ARGUMENTS(( void ));
extern void sem_append_str_to_cstr  _ARGUMENTS(( sym_value_entry_type *az_cstr_entry , sym_value_entry_type *az_str_entry , boolean op2_temporary ));
extern void sem_append_cstr_to_cstr  _ARGUMENTS(( sym_value_entry_type *az_cstr1_entry , sym_value_entry_type *az_cstr2_entry , boolean op2_temporary ));
extern sym_value_entry_type *sem_cat_str_to_str  _ARGUMENTS(( sym_value_entry_type *az_str1_entry , boolean op1_temporary , sym_value_entry_type *az_str2_entry , boolean op2_temporary ));
extern int sem_map_subclass_to_charset  _ARGUMENTS(( int charset_as_subclass ));
extern void sar_charset_verify  _ARGUMENTS(( yystype *charset_frame ));
extern void sar_chk_charset_attr  _ARGUMENTS(( yystype *target_frame , yystype *value_frame , yystype *prior_value_frame ));
extern void sar_make_charset  _ARGUMENTS(( yystype *target_frame , yystype *value_frame , yystype *attr_frame , yystype *keyword_frame ));

/* uilsarexp.c */
extern void sar_binary_op  _ARGUMENTS(( yystype *operator_frame , yystype *op1_frame , yystype *op2_frame ));
extern void sar_unary_op  _ARGUMENTS(( yystype *operator_frame , yystype *op1_frame ));

/* uilsarinc.c */
extern void sar_include_file  _ARGUMENTS(( yystype *file_frame , yystype *include_frame , yystype *semi_frame ));

/* uilsarmod.c */
extern void sar_initialize  _ARGUMENTS(( void ));
extern void sar_create_root  _ARGUMENTS(( yystype *root_frame ));
extern void sar_create_module  _ARGUMENTS(( yystype *target_frame , yystype *id_frame , yystype *module_frame ));
extern void sar_process_module_version  _ARGUMENTS(( yystype *value_frame , yystype *start_frame ));
extern void sar_process_module_sensitivity  _ARGUMENTS(( yystype *token_frame , yystype *start_frame ));
extern void sar_process_module_charset  _ARGUMENTS(( yystype *token_frame , yystype *start_frame ));
extern void sar_save_module_source  _ARGUMENTS(( void ));
extern void sar_make_def_obj  _ARGUMENTS(( yystype *object_frame ));
extern void sar_process_module_variant  _ARGUMENTS(( yystype *obj_type_frame , yystype *variant_frame ));
extern void sar_save_section_source  _ARGUMENTS(( yystype *header_frame , int section_type ));

/* uilsarobj.c */
extern void sar_create_object  _ARGUMENTS(( yystype *object_frame , unsigned char object_type ));
extern void sar_link_section  _ARGUMENTS(( yystype *id_frame ));
extern void sar_save_src_semicolon_pos  _ARGUMENTS(( yystype *semi_frame ));
extern void sar_save_list_end  _ARGUMENTS(( yystype *close_frame ));
extern void sar_save_src_entry_end  _ARGUMENTS(( yystype *close_frame , yystype *entry_frame ));
extern void sar_set_object_flags  _ARGUMENTS(( yystype *current_frame , unsigned char mask ));
extern void sar_unset_object_flags  _ARGUMENTS(( yystype *current_frame , unsigned char mask ));
extern void sar_set_list_type  _ARGUMENTS(( yystype *current_frame ));
extern void sar_set_object_class  _ARGUMENTS(( yystype *current_frame ));
extern void sar_set_object_variant  _ARGUMENTS(( yystype *current_frame ));
extern yystype *sem_find_object  _ARGUMENTS(( yystype *current_frame ));
extern void sar_object_reference  _ARGUMENTS(( yystype *ref_frame ));
extern void sar_update_parent_list  _ARGUMENTS(( yystype *control_list_frame ));
extern void parent_list_traverse  _ARGUMENTS(( sym_widget_entry_type *widget_entry , sym_list_entry_type *control_list_entry ));
extern void sar_save_feature  _ARGUMENTS(( yystype *feature_frame ));
extern void sar_save_argument_pair  _ARGUMENTS(( yystype *argument_frame , yystype *value_frame , yystype *equals_frame ));
extern void sar_save_reason_binding  _ARGUMENTS(( yystype *reason_frame , yystype *proc_ref_frame , yystype *equals_frame ));
extern void sar_save_control_item  _ARGUMENTS(( yystype *managed_frame , yystype *item_frame ));
extern void sar_save_control_widget  _ARGUMENTS(( yystype *control_frame , yystype *item_frame ));
extern void sar_save_user_proc_ref_src  _ARGUMENTS(( yystype *procedure_frame , yystype *proc_id_frame , yystype *proc_arg_frame ));
extern void sar_process_proc_ref  _ARGUMENTS(( yystype *proc_id_frame , yystype *proc_arg_frame , int context ));
extern void sar_add_list_entry  _ARGUMENTS(( yystype *entry_frame ));
extern void sar_add_forward_list_entry  _ARGUMENTS(( yystype *entry_frame ));
extern void sar_verify_object  _ARGUMENTS(( yystype *current_frame ));
extern sym_entry_type *sem_allocate_node  _ARGUMENTS(( unsigned char node_tag , unsigned short node_size ));
extern void sem_free_node  _ARGUMENTS(( sym_entry_type *node_ptr ));

/* uilsarproc.c */
extern void sar_create_procedure  _ARGUMENTS(( const yystype *id_frame , const yystype *param_frame , const yystype *class_frame , const yystype *semi_frame ));
extern sym_proc_ref_entry_type *sem_reference_procedure  _ARGUMENTS(( const yystype *id_frame , const yystype *value_frame , const int context ));
extern sym_entry_type *sem_ref_name  _ARGUMENTS(( const yystype *id_frame , const int tag ));

/* uilsarval.c */
extern void sar_map_keyword_to_name  _ARGUMENTS(( yystype *target_frame , yystype *keyword_frame ));
extern void sar_process_id  _ARGUMENTS(( yystype *target_frame , yystype *id_frame ));
extern void sar_process_id_ref  _ARGUMENTS(( yystype *id_frame ));
extern void sar_make_private_value  _ARGUMENTS(( yystype *value_frame , yystype *token_frame , int value_type , yystype *keyword_frame , int arg_type ));
extern void sar_make_rgb_private_value  _ARGUMENTS(( yystype *value_frame , yystype *token_frame , int value_type , yystype *keyword_frame , int arg_type ));
extern void sar_append_table_value  _ARGUMENTS(( yystype *value_frame , yystype *table_frame , int table_type , yystype *comma_frame ));
extern void sar_value_not_implemented  _ARGUMENTS(( yystype *value_frame , yystype *token_frame , char *error_text ));
extern void sar_cat_value  _ARGUMENTS(( yystype *operator_frame , yystype *op1_frame , yystype *op2_frame ));
extern void sar_chk_comp_str_attr  _ARGUMENTS(( yystype *target_frame , yystype *value_frame , yystype *prior_value_frame ));
extern void sar_make_comp_str  _ARGUMENTS(( yystype *target_frame , yystype *value_frame , yystype *attr_frame , yystype *keyword_frame ));
extern void sar_value_type_error  _ARGUMENTS(( yystype *value_frame , int expected_type ));
extern void sar_private_error  _ARGUMENTS(( yystype *value_frame ));
extern void sar_import_value_entry  _ARGUMENTS(( yystype *target_frame , yystype *token_frame ));
extern void sar_bind_value_name  _ARGUMENTS(( yystype *id_frame , yystype *value_frame , yystype *semi_frame ));
extern sym_name_entry_type *sem_dcl_name  _ARGUMENTS(( yystype *id_frame ));
extern sym_value_entry_type *sem_create_value_entry  _ARGUMENTS(( char *value , int length , int value_type ));
extern void sar_create_identifier  _ARGUMENTS(( const yystype *id_frame , const yystype *semi_frame ));
extern void sar_make_font_table  _ARGUMENTS(( yystype *target_frame , yystype *font_frame , yystype *prior_target_frame , yystype *keyword_frame ));
extern void sar_make_font_item  _ARGUMENTS(( yystype *target_frame , yystype *charset_frame , yystype *font_frame ));
extern void sar_make_font  _ARGUMENTS(( yystype *target_frame , yystype *charset_frame , yystype *value_frame , yystype *keyword_frame ));
extern void sar_make_color_item  _ARGUMENTS(( yystype *target_frame , yystype *color_frame , yystype *letter_frame ));
extern void sar_append_color_item  _ARGUMENTS(( yystype *target_frame , yystype *item_frame , yystype *prior_target_frame ));
extern void sar_make_color_table  _ARGUMENTS(( yystype *target_frame , yystype *list_frame , yystype *keyword_frame ));
extern void sar_make_color  _ARGUMENTS(( yystype *target_frame , yystype *color_frame , yystype *mono_frame , yystype *keyword_frame ));
extern void sar_make_icon  _ARGUMENTS(( yystype *target_frame , yystype *list_frame , yystype *table_frame , yystype *keyword_frame ));

/* uilsemcset.c */
extern char *sem_charset_name  _ARGUMENTS(( int l_charset , sym_value_entry_type *az_charset_entry ));
extern void sem_charset_info  _ARGUMENTS(( int l_charset , sym_value_entry_type *az_charset_entry , int *write_direction , int *parse_direction , int *sixteen_bit ));
extern int sem_charset_lang_name  _ARGUMENTS(( char *lang_charset ));

/* uilsemval.c */
typedef	union  	{
	    boolean	boolean_value;
	    int		integer_value;
	    double	real_value;
	    char        character_value;   /* character data type RAP */
	    float       single_float_value; /* single float data type RAP */
	} data_value_type;

extern void sem_validation  _ARGUMENTS(( void ));
extern void sem_validate_node  _ARGUMENTS(( sym_entry_type *node ));
extern sym_value_entry_type *sem_validate_value_node  _ARGUMENTS(( sym_value_entry_type *value_node ));
extern void sem_validate_widget_node  _ARGUMENTS(( sym_widget_entry_type *widget_node ));
extern void sem_validate_argument_list  _ARGUMENTS(( sym_widget_entry_type *widget_node , unsigned int widget_type , sym_list_entry_type *list_entry , sym_argument_entry_type **seen ));
extern void sem_validate_argument_entry  _ARGUMENTS(( sym_widget_entry_type *widget_node , unsigned int widget_type , sym_list_entry_type *list_entry , sym_argument_entry_type *argument_entry , sym_argument_entry_type **seen ));
extern void sem_validate_argument_enumset  _ARGUMENTS(( sym_argument_entry_type *argument_entry , int arg_code , sym_value_entry_type *arg_value_entry ));
extern void sem_validate_constraint_entry  _ARGUMENTS(( sym_widget_entry_type *widget_node , sym_argument_entry_type *argument_entry ));
extern void sem_validate_callback_list  _ARGUMENTS(( sym_widget_entry_type *widget_node , unsigned int widget_type , sym_list_entry_type *list_entry , sym_callback_entry_type **seen ));
extern void sem_validate_callback_entry  _ARGUMENTS(( sym_widget_entry_type *widget_node , unsigned int widget_type , sym_list_entry_type *list_entry , sym_callback_entry_type *callback_entry , sym_callback_entry_type **seen ));
extern void sem_validate_control_list  _ARGUMENTS(( sym_widget_entry_type *widget_node , unsigned int widget_type , sym_list_entry_type *list_entry , int *count ));
extern void sem_validate_control_entry  _ARGUMENTS(( sym_widget_entry_type *widget_node , unsigned int widget_type , sym_list_entry_type *list_entry , sym_control_entry_type *control_entry , int *gadget_count ));
extern void sem_validate_widget_cycle  _ARGUMENTS(( sym_list_entry_type *list_entry , sym_name_entry_type *cycle_name ));
extern boolean sem_validate_widget_cycle_aux  _ARGUMENTS(( sym_list_entry_type *list_entry , sym_name_entry_type *cycle_name ));
extern boolean sem_validate_verify_cycle  _ARGUMENTS(( sym_widget_entry_type *cycle_obj , sym_list_entry_type *list_entry ));
extern void sem_validate_procref_list  _ARGUMENTS(( sym_list_entry_type *list_entry ));
extern void sem_validate_procref_entry  _ARGUMENTS(( sym_proc_ref_entry_type *procref_entry ));
extern boolean sem_argument_allowed  _ARGUMENTS(( unsigned int arg_code , unsigned int class_code ));
extern boolean sem_reason_allowed  _ARGUMENTS(( unsigned int rsn_code , unsigned int class_code ));
extern boolean sem_control_allowed  _ARGUMENTS(( unsigned int ctl_code , unsigned int class_code ));
extern sym_value_entry_type *sem_evaluate_value  _ARGUMENTS(( sym_value_entry_type *val_entry ));
extern sym_value_entry_type *sem_evaluate_value_cs  _ARGUMENTS(( sym_value_entry_type *csval_entry ));
extern sym_value_entry_type *sem_evaluate_value_expr  _ARGUMENTS(( sym_value_entry_type *value_entry ));
extern int validate_arg  _ARGUMENTS(( sym_value_entry_type *operand_entry , int v_operator ));
extern int sem_convert_to_float  _ARGUMENTS(( sym_value_entry_type *operand_entry , data_value_type *data_value ));
extern int sem_convert_to_integer  _ARGUMENTS(( sym_value_entry_type *operand_entry , data_value_type *data_value ));
extern int sem_convert_to_single_float  _ARGUMENTS(( sym_value_entry_type *operand_entry , data_value_type *data_value ));
extern int sem_convert_to_error  _ARGUMENTS(( sym_value_entry_type *operand_entry , data_value_type *data_value ));
extern void sar_cat_value_entry  _ARGUMENTS(( sym_value_entry_type **target_entry , sym_value_entry_type *op1_entry , sym_value_entry_type *op2_entry ));

/* uilsrcsrc.c */
extern void src_initialize_source  _ARGUMENTS(( void ));
extern void Uil_src_cleanup_source  _ARGUMENTS(( void ));
extern void src_open_file  _ARGUMENTS(( const char *c_file_name , char *full_file_name ));
extern status src_get_source_line  _ARGUMENTS(( void ));
extern status open_source_file  _ARGUMENTS(( const char *c_file_name , uil_fcb_type *az_fcb , const src_source_buffer_type *az_source_buffer ));
extern status close_source_file  _ARGUMENTS(( uil_fcb_type *az_fcb ));
extern status get_line  _ARGUMENTS(( uil_fcb_type *az_fcb ));
extern boolean reget_line  _ARGUMENTS(( uil_fcb_type *az_fcb , char *c_buffer , const z_key *z_access_key ));
extern char *src_get_file_name  _ARGUMENTS(( const src_source_record_type *az_src_rec ));
extern boolean src_retrieve_source  _ARGUMENTS(( const src_source_record_type *az_src_rec , char *c_buffer ));
extern void src_append_diag_info  _ARGUMENTS(( const src_source_record_type *az_src_rec , const int l_src_pos , const char *c_msg_text , const int l_msg_number ));
extern void src_append_machine_code  _ARGUMENTS(( const src_source_record_type *az_src_rec , const int l_offset , const int l_code_len , const char *c_code , const char *c_text_arg ));

/* uilsymnam.c */
extern sym_name_entry_type *sym_find_name  _ARGUMENTS(( int l_length , char *c_text ));
extern sym_name_entry_type *sym_insert_name  _ARGUMENTS(( int l_length , char *c_text ));
extern int hash_function  _ARGUMENTS(( int l_length , char *c_value ));
#if debug_version
extern void sym_dump_hash_table  _ARGUMENTS(( void ));
#endif

/* uilsymstor.c */
extern void sym_initialize_storage  _ARGUMENTS(( void ));
extern void Uil_sym_cleanup_storage  _ARGUMENTS(( boolean freealloc ));
extern void sym_make_external_def  _ARGUMENTS(( const sym_name_entry_type *az_name ));
extern void sym_make_forward_ref  _ARGUMENTS(( const yystype *az_id_frame , const int l_widget_type , const char *a_location ));
extern void sym_make_value_forward_ref  _ARGUMENTS(( const yystype *az_value_frame , const char *a_location , const unsigned char fwd_ref_flags ));
extern void UilDumpSymbolTable  _ARGUMENTS(( sym_entry_type *node_entry ));
extern void sym_dump_symbols  _ARGUMENTS(( void ));
extern void sym_dump_symbol  _ARGUMENTS(( sym_entry_type *az_symbol_entry ));
extern void sym_dump_widget  _ARGUMENTS(( const sym_widget_entry_type *az_widget_entry ));
extern void sym_dump_argument  _ARGUMENTS(( const sym_argument_entry_type *az_argument_entry ));
extern void sym_dump_control  _ARGUMENTS(( const sym_control_entry_type *az_control_entry ));
extern void sym_dump_callback  _ARGUMENTS(( const sym_callback_entry_type *az_callback_entry ));
extern void sym_dump_list  _ARGUMENTS(( const sym_list_entry_type *az_list_entry ));
extern void sym_dump_name  _ARGUMENTS(( const sym_name_entry_type *az_name_entry ));
extern void sym_dump_module  _ARGUMENTS(( const sym_module_entry_type *az_module_entry ));
extern void sym_dump_color_item  _ARGUMENTS(( const sym_color_item_entry_type *az_color_item_entry ));
extern void sym_dump_parent_list_item  _ARGUMENTS(( const sym_parent_list_type *az_parent_list_item ));
extern void sym_dump_external_def  _ARGUMENTS(( const sym_external_def_entry_type *az_external_def_entry ));
extern void sym_dump_proc_def  _ARGUMENTS(( const sym_proc_def_entry_type *az_proc_def_entry ));
extern void sym_dump_proc_ref  _ARGUMENTS(( const sym_proc_ref_entry_type *az_proc_ref_entry ));
extern void sym_dump_forward_ref  _ARGUMENTS(( const sym_forward_ref_entry_type *az_forward_ref_entry ));
extern void sym_dump_value  _ARGUMENTS(( const sym_value_entry_type *az_value_entry ));
extern void output_text  _ARGUMENTS(( const int length , const char *text ));
extern void sym_dump_source_info  _ARGUMENTS(( sym_entry_header_type *hdr ));
extern void sym_dump_obj_header  _ARGUMENTS(( const sym_obj_entry_type *az_obj_entry ));
extern void sym_dump_include_file  _ARGUMENTS(( sym_include_file_entry_type *az_symbol_entry ));
extern void sym_dump_section  _ARGUMENTS(( sym_section_entry_type *az_symbol_entry ));
extern void sym_dump_object_variant  _ARGUMENTS(( sym_def_obj_entry_type *az_symbol_entry ));
extern void sym_dump_root_entry  _ARGUMENTS(( sym_root_entry_type *az_symbol_entry ));
extern char *sym_section_text  _ARGUMENTS(( int b_type ));
extern void dump_free_list  _ARGUMENTS(( void ));

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* UilDef_h */
/* DON'T ADD STUFF AFTER THIS #endif */
