/*ident	"@(#)C++env:incl-master/proto-headers/sys/utsname.h	1.1" */

#ifndef __UTSNAME_H
#define __UTSNAME_H

#define uname ______uname

/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: utsname.h,v 1.15.2.1 88/09/23 22:15:27 himel Exp $ */

#ifndef	_SYS_UTSNAME_
#define	_SYS_UTSNAME_

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/


/* NOTE:
 * The MIPS' naming convention for all utsname strings requires the strings
 * to be legitimate cpp "names" (e.g. no '.', '/', etc.).
 *
 * Only "nodename" and "sysname" should be defined by the system administrator.
 * The rest of the strings should be defined at configuration or boot time
 * using the constants defined in this file.
 *
 * "sys/limits.h" must be included because it defines SYS_NMLN
 */

#include <sys/limits.h>	/* Include(s) required before this one. */

struct utsname {
	char	sysname[SYS_NMLN];	/* same as nodename field */
	char	nodename[SYS_NMLN];	/* network id name (user defined) */
	char	release[SYS_NMLN];	/* MIPS OS release name */
	char	version[SYS_NMLN];	/* MIPS OS version number */
	char	machine[SYS_NMLN];	/* MIPS system type */
	char	m_type[SYS_NMLN];	/* MIPS specific machine type */
	char	base_rel[SYS_NMLN];	/* base release for initial port */
	char	reserve5[SYS_NMLN];	/* reserved for future use */
	char	reserve4[SYS_NMLN];	/* reserved for future use */
	char	reserve3[SYS_NMLN];	/* reserved for future use */
	char	reserve2[SYS_NMLN];	/* reserved for future use */
	char	reserve1[SYS_NMLN];	/* reserved for future use */
	char	reserve0[SYS_NMLN]	/* reserved for future use */
};

	/* valid release values */
#define R_2_0		"2_0"
#define R_3_0		"3_0"
#define R_3_1		"3_1"
#define R_3_2		"3_2"
#define R_3_10		"3_10"

	/* valid version values */
#define V_UMIPSBSD	"UMIPS_BSD"
#define V_UMIPSV	"UMIPS_V"
#define V_UMIPS		"UMIPS"

	/* machine value is the same as what cpp defines */
#define M_MIPS		"mips"

	/* valid m_type values */
#define MT_M500		"m500"
#define MT_M800		"m800"
#define MT_M1000	"m1000"
#define MT_DT1200_5	"m120-5"
#define MT_DT1200_3	"m120-3"
#define MT_DT1200	"m120"		/* Obsolete - here to not bust stuff */
#define MT_M2000_8	"m2000-8"
#define MT_M2000_6	"m2000-6"
#define MT_M2000	"m2000"		/* Obsolete - here not to bust stuff */

	/* valid base release values */
#define BR_V30_ATT	"ATT_V3_0"
#define BR_V31_ATT	"ATT_V3_1"
#define BR_43_BSD	"4_3_BSD"

#if defined KERNEL || defined INKERNEL
extern struct utsname	utsname;
extern char		hostname[];
extern short		hostnamelen;
extern char		domainname[];
extern short		domainnamelen;
#endif

#endif
 

#undef uname

extern "C" {
	int uname(struct utsname *);
}
#endif
