/*ident	"@(#)C++env:incl-master/proto-headers/sys/statfs.h	1.1" */

#ifndef __STATFS_H
#define __STATFS_H

#define statfs ______statfs
#define fstatfs ______fstatfs

/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: statfs.h,v 1.6.1.1 88/09/23 22:13:47 himel Exp $ */

#ifndef	_SYS_STATFS_
#define	_SYS_STATFS_	1


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * Structure returned by the statfs() system call.
 */

struct	statfs {
	short	f_fstyp;	/* File system type */
	long	f_bsize;	/* Block size */
	long	f_frsize;	/* Fragment size (if supported) */
	long	f_blocks;	/* Total number of blocks on file system */
	long	f_bfree;	/* Total number of free blocks */
	long	f_files;	/* Total number of file nodes (inodes) */
	long	f_ffree;	/* Total number of free file nodes */
	char	f_fname[6];	/* Volume name */
	char	f_fpack[6];	/* Pack name */
};

#endif
 

#undef statfs
#undef fstatfs

extern "C" {
	int statfs(const char *, struct statfs *, int, int);
	int fstatfs(int, struct statfs *, int, int);
}

#endif

