#ifndef __RWBLOCK_H__
#define __RWBLOCK_H__

/*
 * Declarations for reference counted block.
 *
 * $Id: rwblock.h,v 3.4.2.1 90/10/22 15:54:06 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989, 1990. This software is subject to copyright 
 * protection under the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

/*
 * This is the dynamically allocated part of a vector.
 */

#include "mathdefs.h"

class RWBlock {
private:
  unsigned short	refs;		/* Number of references*/
  void*			array;		/* The data*/
public:
  RWBlock(unsigned nelem, size_t elemsize);
  ~RWBlock();

  void			add_reference()	{refs++;}
  unsigned		references()	{return refs;}
  void*			data()		{return array;}
  void			operator delete(void*);
  void*			operator new(size_t);
};

#endif  /* __RWBLOCK_H__ */
