#ifndef __RSTREAM_H__
#define __RSTREAM_H__

/*
 * Includes either stream.h or iostream.h, depending
 * on the compiler.
 *
 * $Id: rstream.h,v 3.1.1.1 90/10/17 14:10:55 keffer Rel $
 *
 ****************************************************************************
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 * warranty.
 *
 ***************************************************************************
 *
 */

#include "compiler.h"

#ifdef HAS_IOSTREAMS
#  include <iostream.h>
#else
#  include <stream.h>
#endif

#include <generic.h>

/*
 * These macros are useful for opening a stream for use
 * with either V1.2 or V2.0 style streams.
 */

#if HAS_IOSTREAMS
# define OPENOSTREAM(filename, streamname)  ofstream streamname(filename);
# define OPENISTREAM(filename, streamname)  ifstream streamname(filename);
#else
# define OPENOSTREAM(filename, streamname)	\
  filebuf name2(fbuf,streamname);		\
  name2(fbuf,streamname).open(filename,output);	\
  ostream streamname(&name2(fbuf,streamname));
# define OPENISTREAM(filename, streamname)	\
  filebuf name2(fbuf,streamname);		\
  name2(fbuf,streamname).open(filename,input);	\
  istream streamname(&name2(fbuf,streamname));
#endif

#endif /* __RSTREAM_H__ */
