#ifndef __RAND_UNIFORM_H__
#define __RAND_UNIFORM_H__

/*
 * Declarations for RandBinomial: Uniformally distributed random numbers.
 *
 * $Id: randunif.h,v 3.4.2.1 90/10/22 15:52:28 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "dgemat.h"

class RandUniform {
private:
  double		table[97];	/* Shuffling table.*/
  double		index;
protected:
  unsigned 		seeder;	/* Random number generator seed.*/
public:
  RandUniform();		/* Initialize a generator with clock time.*/
  RandUniform(unsigned);	/* Initialize a generator with seed.*/

  unsigned  		seed() Const {return seeder;}

  double    		randValue();	/* Return a random number.*/
  void    		randValue(double*, unsigned n);	/* Return an array of random numbers.*/
  DoubleVec 		randValue(unsigned n);	/* Return a vector of n random numbers.*/
  DGEMatrix 		randValue(unsigned nr, unsigned nc);	/* Return a matrix of random numbers.*/
};
  
#endif

