#ifndef __RAND_POISSON_H__
#define __RAND_POISSON_H__

/*
 * Declarations for RandBinomial: Poisson distributed random numbers.
 *
 * $Id: randpois.h,v 3.4.2.1 90/10/22 15:52:27 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "randunif.h"

class RandPoisson : public RandUniform {
private:		/* Private date used by the algorithms.*/
  double 		g, lmean, sq;
protected:
  double 		p_mean;
public:
  RandPoisson(double m);            
  RandPoisson(unsigned n, double m);
 
  double    		poissonMean() Const     {return p_mean;}
  void      		setPoissonMean(double m);

  double    		randValue();           /* Return a random number */
  void    		randValue(double*, unsigned n);	/* Return an array of random numbers.*/
  DoubleVec 		randValue(unsigned n); /* Return a vector of n random numbers */
  DGEMatrix		randValue(unsigned nr, unsigned nc);  /* Return a matrix of random numbers*/
};

#endif
                                

