#ifndef __RAND_NORMAL_H__
#define __RAND_NORMAL_H__

/*
 * Declarations for RandBinomial: Normally distributed random numbers.
 *
 * $Id: randnorm.h,v 3.4.2.1 90/10/22 15:52:26 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "randunif.h"

class RandNormal : public RandUniform {
public:
  RandNormal()			: RandUniform()  { }
  RandNormal(unsigned n)	: RandUniform(n) { }
 
  double    		randValue();	/* Return a random number.*/
  void    		randValue(double*, unsigned n);	/* Return an array of random numbers.*/
  DoubleVec 		randValue(unsigned n); /* Return a vector of n random numbers. */
  DGEMatrix 		randValue(unsigned nr, unsigned nc);  /* Return a matrix of random numbers.*/
};
  
#endif
                                
