#ifndef __MATHDEFS_H__
#define __MATHDEFS_H__

/*
 * Math.h++ common definitions
 *
 * $Id: mathdefs.h,v 3.4.2.1 90/10/22 15:52:22 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

/* Include general definitions:*/
#include "defs.h"
STARTWRAP
#include <stddef.h>
ENDWRAP

/* GNU overloads these in math.h*/
#if !defined(__GNUG__) && defined(NEEDS_OVERLOAD)
   overload acos;
   overload acosh; 
   overload asin;
   overload asinh;
   overload atan2; 
   overload atan;
   overload atanh;
   overload ceil;
   overload cos;
   overload cosh;
   overload exp;
   overload floor;
   overload gamma;
   overload hypot;
   overload log10;
   overload log;
   overload pow;
   overload sin;
   overload sinh;
   overload sqrt;
   overload tan;
   overload tanh;
   overload cot;
   overload coth;
#endif

/* GNU does some overloading in here:*/
#ifdef __GNUG__
#  include <std.h>
#endif

/* Special math functions:*/
#ifdef NEEDS_OVERLOAD
#  ifndef __GNUG__
   overload abs;		/* GNU overloads in std.h*/
#  endif
   overload ABS1;
   overload cumsum;
   overload delta;
   overload determinant;
   overload dot;
   overload expandConjugateEven;
   overload expandConjugateOdd;
   overload expandEven;
   overload expandOdd;
   overload inverse;
   overload mean;
   overload prod;
   overload reverse;
   overload rootsOfOne;
   overload spectralVariance;
   overload solve;
   overload sum;
   overload transpose;
   overload variance;
#endif

#ifndef TYPE_SAFE_LINKAGE
/* Necessary so this compiler mungs the function names properly.  Otherwise,*/
/* it is unpredictable which type gets which name.*/
   extern void abs(void);
   extern void ABS1(void);
   extern void cumsum(void);
   extern void delta(void);
   extern void determinant(void);
   extern void dot(void);
   extern void expandEven(void);
   extern void expandOdd(void);
   extern void expandConjugateEven(void);
   extern void expandConjugateOdd(void);
   extern void inverse(void);
   extern void mean(void);
   extern void prod(void);
   extern void reverse(void);
   extern void rootsOfOne(void);
   extern void solve(void);
   extern void spectralVariance(void);
   extern void sum(void);
   extern void transpose(void);
   extern void variance(void);
#endif

/* ZTC 2.0 needs the "extern C" wrapper:*/
#if defined(__ZTC__)
  extern "C" { 
    typedef double		(*mathFunTy)(double);
  }
#else
#  if defined(__GNUG__) && defined(__HAVE_68881__)
    /* GNU 68881 inline functions require this:*/
    typedef const double	(*mathFunTy)(double);
#  else
    typedef double		(*mathFunTy)(double);
#  endif
#endif

typedef char Char;	/* In here instead of defs.h for hysterical reasons*/

#ifdef NEEDS_OVERLOAD
overload RWstoreID, RWreadID;
#endif
int  RWreadBin(fileDescTy&,void*,unsigned);
int  RWstoreBin(fileDescTy&,const void*,unsigned);
void RWstoreID(ostream&,    unsigned short);
int  RWstoreID(fileDescTy&, unsigned short);
unsigned short RWreadID(istream&);
unsigned short RWreadID(fileDescTy&);

#endif /* __MATHDEFS_H__ */
