#ifndef __HISTOGRAM_H__
#define __HISTOGRAM_H__

/*
 * Declarations for Histogram Class.
 *
 * $Id: histo.h,v 3.4.2.1 90/10/22 15:52:16 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "ivec.h"
#include "dvec.h"
#include "rstream.h"

class Histogram : public IntVec {
private:
  unsigned   		totalCounts;
  unsigned   		nbins;
  DoubleVec  		binValues;
  unsigned   		largerValues;
  unsigned   		smallerValues;
public:
  /* constructors:*/

  /* Histogram (with n bins), scaled with the min and max of v;*/
  /* Data in v is added to Histogram.*/
  Histogram( unsigned n, const DoubleVec& v );

  /* Histogram with boundaries given by b:*/
  Histogram( const DoubleVec& b );

  /* Histogram with n bins, scaled with bmin and bmax:*/
  Histogram( unsigned n, double bmin, double bmax);

  unsigned  		larger() Const		{return largerValues;}
  unsigned  		smaller() Const		{return smallerValues;}
  unsigned  		bins() Const		{return nbins;}
  DoubleVec 		binBoundaries() Const	{return binValues.copy();}

  void      		addCount(double);
  void      		addCount(const DoubleVec& v);
  unsigned		binaryStoreSize() Const;		/* Storage requirements.*/

friend ostream& 	operator<<(ostream& s, const Histogram& h);

};

#endif
