#ifndef __DLUDECOMP_H__
#define __DLUDECOMP_H__

/*
 * Declarations for Double precision LU Decomposition.
 *
 * $Id: dludecmp.h,v 3.4.2.1 90/10/22 15:52:08 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "dgemat.h"

class DLUDecomp {
  DGEMatrix 		theLUdecomposition;
  int*			ipvt;	/* Pivot indices*/
  int			info;
  int			the_order;
protected:
  void			assertSquare(const DGEMatrix&) Const;
  void			assertDefined() Const;
  void			assertPivots() Const;
  void			assertOrder(unsigned) Const;
public:
  DLUDecomp(const DGEMatrix&);
  ~DLUDecomp();

  unsigned		order() Const  {return (unsigned)the_order;}
  int			isSingular() Const;
  unsigned		binaryStoreSize() Const;		/* Storage requirements.*/

  /* Matrix algebra declarations:*/
  
friend Double		determinant(const DLUDecomp&);
friend DGEMatrix	inverse(const DLUDecomp&);
friend DoubleVec	solve(const DLUDecomp&, const DoubleVec&);
};

/* special absolute value function for linpack routines:*/
Inline  Double ABS1 (Double a) {return ABS(a);} 

#endif /* __DLUDECOMP_H__ */
