#ifndef __RWDEFS_H__
#define __RWDEFS_H__

/*
 * Common definitions
 *
 * $Id: defs.h,v 3.1.1.1 90/10/17 14:10:41 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

/* Set compiler-specific flags:*/
#include "compiler.h"

/*
 *     D E B U G G I N G
 *
 * Use -DRDEBUG to debug the Rogue Wave libraries.
 * This will activate debugging routines, cause verbose output,
 * check worst case situations, etc.
 *
 * Use -DDEBUG to compile a version of the libraries to debug
 * the user's code.  This will perform extra checks, but run
 * more slowly.
 *
 * VERY IMPORTANT!  *All* code must be compiled with the same flag.
 */

#if defined(RDEBUG) && !defined(DEBUG)
#  define DEBUG 1
#endif

#if defined(DEBUG)
#  ifndef BOUNDS_CHECK
#    define BOUNDS_CHECK 1	/* Turn on bounds checking when debugging. */
#  endif
#  if defined(__ATT2__) || defined(__TURBOC__)
#    define Inline inline
#  else
#    define Inline static
#  endif
#else
#  define Inline inline
#endif

#define nil     	0
#define	NIL    		-1L
#define NL		"\n"

#ifndef TRUE
#   define TRUE		1
#   define FALSE	0
#endif
typedef int RWBoolean;
/* The following is for your convenience and can be removed*/
/* if it conflicts with some other package:*/
#define Boolean RWBoolean

#define ENULL		1.0e35
#define RWSUCCESS	0
#define STASHSIZE	10	/* Small object pool size */

/* No RCS for MS-DOS (its got enough memory problems already!): */
#ifdef __MSDOS__
#define RCSID(a)
#else
#define RCSID(a) static char rcsid[] = a
#endif

#if defined(__ATT1__)
/* Bug in ATT1 does not allow typedefs:*/
#  define Double	double
#  define Float		float
#  define Int		int
#else
   typedef double	Double;
   typedef float	Float;
   typedef int		Int;
#endif

typedef unsigned char	UChar; 
#if defined(__ATT__)
  typedef char		SChar;
#else
  typedef signed char	SChar;   
#endif

typedef unsigned short	ClassID; /* Class ID tag.*/
typedef int		fileDescTy; /* Type of file descriptors*/

enum RWSeverity {RWWARNING, RWDEFAULT, RWFATAL};
void RWError(RWSeverity, const char*, const char*);

#ifndef TYPE_SAFE_LINKAGE
/* Necessary so the compiler mangles the function names properly.*/
/* Otherwise, it is unpredictable which type gets which name.*/
  extern void ABS(void);
  extern void max(void);
  extern void min(void);
  extern void toChar(void);
  extern void toFloat(void);
  extern void toInt(void);
#endif
  
/* ATT 1.2 cannot tell an overloaded int from a char:*/
#if !defined(__ATT1__)
  Inline char		ABS(char a)	{return (a>0) ? a : -a;}
#endif

Inline double		ABS(double a)	{return (a>0) ? a : -a;}
Inline int		ABS(int a)	{return (a>0) ? a : -a;}

Inline double		max(double a, double b)	{return a>b? a : b;}
Inline double		min(double a, double b) {return a<b? a : b;}
Inline int		max(int a, int b)	{return a>b? a : b;}
Inline int		min(int a, int b)	{return a<b? a : b;}

class istream;
class ostream;
class RWFile;

#endif /* __RWDEFS_H__ */
