#ifndef __DCOMPLEX_H__
#define __DCOMPLEX_H__

/*
 * DComplex -- Rogue Wave generic double precision complex.
 *
 * $Id: dcomplex.h,v 3.4.2.1 90/10/22 15:52:03 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

/*
 * Because there are so many variations of "Complex" types, this 
 * header file attempts to standardize what the user sees.  If you
 * include this header file and use type "DComplex" (for double
 * precision complex) you generally need not worry about what
 * compiler you are using.
 */

#include "mathdefs.h"

/* Define TRUE if sizeof(Complex)==2*sizeof(double);*/
/* This is true for all known compilers:*/
#define COMPLEX_PACKS 1

/* Define TRUE if complex member data goes (real, imaginary), FALSE otherwise:*/
#define REAL_LEADS 1

/* * * *  Figure out which header file to use, depending on the compiler: * * * */


/****************************  GNU  ***********************************/

/*
 * The GNU library uses a capital "C", and passes by
 * reference.
 */

#ifdef __GNUG__
#  include <Complex.h>
#  define DComplex Complex
   typedef DComplex (*CmathFunTy)(const DComplex&);
   typedef double (*CmathFunTy2)(const DComplex&);
#endif

/*************************  AT&T  ***********************************/

/*
 * The AT&T compilers uses a small "c", and passes by
 * value, EXCEPT for real and imag.
 * Note: If you are using the AT&T Version 1.2 compiler, 
 * you MUST modify the complex.h file in accordance with
 * the instructions in the Math.h++ manual!
 */

#ifdef __ATT__

#  include <complex.h>

#  define  DComplex complex
   typedef DComplex (*CmathFunTy)(DComplex);
   typedef double  (*CmathFunTy2)(DComplex);
#endif

/*************************  Turbo C++  ************************/

/*
 * Turbo C++ uses a small "c" and passes by reference.
 */

#ifdef __TURBOC__
#  include <complex.h>
#  define DComplex complex
   typedef DComplex (*CmathFunTy)(DComplex&);
   typedef double (*CmathFunTy2)(DComplex&);
#endif

/*************************  Zortech or Oregon C++  ************************/

/*
 * Zortech V2.06 and Oregon Software do not supply a complex class.
 * Zortech V2.1 does supply a complex class, but it has some
 * errors in it (type conversion does not work, pow() and other
 * transcendentals are not implemented correctly).
 *
 * Use the Rogue Wave supplied complex class, which generally follows 
 * the AT&T standard.
 */

#if defined(__ZTC__) || defined(__OREGON__)
#  include "rcomplex.h"
#  define complex DComplex
   typedef DComplex (*CmathFunTy)(DComplex);
   typedef double  (*CmathFunTy2)(DComplex);
#endif

/*************************  All  ***********************************/

inline double ABS(DComplex& v){return abs(v);}

#endif /* __DCOMPLEX_H__ */
