/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1990 MIPS Computer Systems, Inc.            |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 52.227-7013.   |
 * |         MIPS Computer Systems, Inc.                       |
 * |         928 Arques Avenue                                 |
 * |         Sunnyvale, CA 94086                               |
 * |-----------------------------------------------------------|
 */
/* $Header: stdlib.h,v 1.4.1.3 90/05/10 04:09:30 wje Exp $ */

#ifndef	_POSIX_STDLIB_
#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */
#define	_POSIX_STDLIB_	1

#ifndef	NULL
		#undef NULL
#define	NULL	0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef	unsigned int	size_t;
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef	long		wchar_t;
#endif

typedef	struct { int quot; int rem; }   div_t;	/* type returned by div() */
typedef	struct { long quot; long rem; } ldiv_t;	/* type returned by ldiv() */

#define	EXIT_SUCCESS	0
#define	EXIT_FAILURE	(-1)

#define	RAND_MAX	0x7fff
#define	MB_CUR_MAX	(sizeof(char))

extern	int		abs _PARAMS((int));
extern	double		atof _PARAMS((const char *)); 
extern	int		atoi _PARAMS((const char *)); 
extern	long int	atol _PARAMS((const char *));
extern 	int		rand(), srand _PARAMS((unsigned int)); 
extern 	char		*malloc _PARAMS((__SIZE_TYPE__ )), *calloc _PARAMS((__SIZE_TYPE__ , __SIZE_TYPE__ )), *realloc _PARAMS((void *, __SIZE_TYPE__ ));
extern 	void		free _PARAMS((void *));
extern 	void		abort(), exit _PARAMS((int));
extern	char		*getenv _PARAMS((const char *));
extern	char		*bsearch _PARAMS((const void *, const void *, __SIZE_TYPE__ , __SIZE_TYPE__ , int (*) (const void *, const void *)));
extern	void		qsort _PARAMS((void *, __SIZE_TYPE__ , __SIZE_TYPE__ , int (*) (const void *, const void *)));
#endif
